/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.feet;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicAttributeModifier;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootEntries;
import it.hurts.sskirillss.relics.items.relics.base.data.research.ResearchData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.PacketItemActivation;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingFallEvent;
import top.theillusivec4.curios.api.SlotContext;

public class KittySlippersItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"passive").maxLevel(0).build()).ability(AbilityData.builder((String)"fall").stat(StatData.builder((String)"modifier").initialValue(2.0, 4.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.4).formatValue(value -> MathUtils.round((double)value, (int)1)).build()).research(ResearchData.builder().star(0, 6, 24).star(1, 2, 19).star(2, 2, 9).star(3, 6, 4).star(4, 16, 4).star(5, 20, 9).star(6, 20, 19).star(7, 16, 24).star(8, 11, 16).star(9, 8, 19).star(10, 5, 13).star(11, 8, 8).star(12, 14, 19).star(13, 17, 13).star(14, 14, 8).link(0, 1).link(1, 2).link(2, 3).link(3, 4).link(4, 5).link(5, 6).link(6, 7).link(7, 0).link(8, 9).link(9, 10).link(8, 11).link(8, 12).link(12, 13).link(8, 14).build()).build()).ability(AbilityData.builder((String)"resurrected").requiredLevel(5).stat(StatData.builder((String)"chance").initialValue(0.05, 0.1).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.25).formatValue(value -> MathUtils.round((double)(value * 100.0), (int)1)).build()).research(ResearchData.builder().star(0, 6, 25).star(1, 2, 20).star(2, 2, 9).star(3, 6, 4).star(4, 16, 4).star(5, 20, 9).star(6, 20, 20).star(7, 16, 25).star(8, 15, 21).star(9, 13, 17).star(10, 7, 13).star(11, 4, 17).star(12, 17, 12).star(13, 16, 8).link(0, 1).link(1, 2).link(2, 3).link(3, 4).link(4, 5).link(5, 6).link(6, 7).link(7, 0).link(8, 9).link(9, 10).link(10, 11).link(9, 12).link(12, 13).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-1184275).borderBottom(-9868951).build()).beams(BeamsData.builder().startColor(-4359773).endColor(0x2C2C2C).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(15).step(100).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"fall").initialValue(1).gem(GemShape.SQUARE, GemColor.PURPLE).build()).source(LevelingSourceData.abilityBuilder((String)"resurrected").initialValue(1).gem(GemShape.SQUARE, GemColor.PURPLE).build()).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.TROPIC, LootEntries.VILLAGE}).build()).build();
    }

    public RelicAttributeModifier getRelicAttributeModifiers(ItemStack stack) {
        return RelicAttributeModifier.builder().attribute(new RelicAttributeModifier.Modifier(Attributes.SAFE_FALL_DISTANCE, (float)this.getStatValue(stack, "fall", "modifier") / 3.0f)).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        float yaw;
        Path path;
        PathNavigation navigation;
        Vec3 escapePosition;
        Vec3 escapeDirection;
        Player player;
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).getCommandSenderWorld().isClientSide()) {
            return;
        }
        Level level = player.getCommandSenderWorld();
        for (Creeper creeper : level.getEntitiesOfClass(Creeper.class, player.getBoundingBox().inflate(5.0))) {
            Vec3 creeperPosition = creeper.position();
            escapeDirection = player.position().subtract(creeperPosition).normalize().scale(-1.0);
            escapePosition = creeperPosition.add(escapeDirection.scale(5.0));
            navigation = creeper.getNavigation();
            path = navigation.createPath(escapePosition.x, escapePosition.y, escapePosition.z, 0);
            if (path != null) {
                navigation.moveTo(path, 1.5);
            }
            creeper.setTarget(null);
            creeper.yBodyRot = yaw = (float)Math.toDegrees(Math.atan2(escapeDirection.z, escapeDirection.x));
            creeper.yHeadRot = yaw;
        }
        for (Phantom phantom : level.getEntitiesOfClass(Phantom.class, player.getBoundingBox().inflate(5.0))) {
            Vec3 phantomPosition = phantom.position();
            escapeDirection = player.position().subtract(phantomPosition).normalize().scale(-1.0);
            escapePosition = phantomPosition.add(escapeDirection.scale(5.0));
            navigation = phantom.getNavigation();
            path = navigation.createPath(escapePosition.x, escapePosition.y, escapePosition.z, 0);
            if (path != null) {
                navigation.moveTo(path, 1.5);
            }
            phantom.setTarget(null);
            phantom.yBodyRot = yaw = (float)Math.toDegrees(Math.atan2(escapeDirection.z, escapeDirection.x));
            phantom.yHeadRot = yaw;
        }
    }

    @EventBusSubscriber
    public static class KittySlippersEvent {
        @SubscribeEvent
        public static void onLivingChangeTargetEvent(LivingChangeTargetEvent event) {
            LivingEntity livingEntity;
            if ((event.getEntity() instanceof Creeper || event.getEntity() instanceof Phantom) && (livingEntity = event.getNewAboutToBeSetTarget()) instanceof Player) {
                Player player = (Player)livingEntity;
                ItemStack itemStack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.KITTY_SLIPPERS.value()));
                if (!(itemStack.getItem() instanceof KittySlippersItem)) {
                    return;
                }
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onLivingHurt(LivingDamageEvent.Pre event) {
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player)) {
                return;
            }
            Player player = (Player)livingEntity;
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.KITTY_SLIPPERS.value()));
            if (!(stack.getItem() instanceof KittySlippersItem)) {
                return;
            }
            stack.set((Supplier)DataComponentRegistry.COUNT, (Object)((int)event.getOriginalDamage()));
        }

        @SubscribeEvent
        public static void onPlayerFall(LivingFallEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player)) {
                return;
            }
            Player player = (Player)livingEntity;
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.KITTY_SLIPPERS.value()));
            Item item = stack.getItem();
            if (!(item instanceof KittySlippersItem)) {
                return;
            }
            KittySlippersItem relic = (KittySlippersItem)item;
            if (event.getDistance() > 4.0f) {
                relic.spreadRelicExperience((LivingEntity)player, stack, 1);
            }
        }

        @SubscribeEvent
        public static void onLivingDeath(LivingDeathEvent event) {
            KittySlippersItem relic;
            RandomSource random;
            Level level;
            ItemStack stack;
            Player player;
            block6: {
                block5: {
                    LivingEntity livingEntity = event.getEntity();
                    if (!(livingEntity instanceof Player)) {
                        return;
                    }
                    player = (Player)livingEntity;
                    stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.KITTY_SLIPPERS.value()));
                    level = player.getCommandSenderWorld();
                    random = player.getRandom();
                    Item item = stack.getItem();
                    if (!(item instanceof KittySlippersItem)) break block5;
                    relic = (KittySlippersItem)item;
                    if (!level.isClientSide() && relic.canPlayerUseAbility(player, stack, "resurrected") && !((double)random.nextFloat() > relic.getStatValue(stack, "resurrected", "chance"))) break block6;
                }
                return;
            }
            NetworkHandler.sendToClient((CustomPacketPayload)new PacketItemActivation(stack), (ServerPlayer)((ServerPlayer)player));
            level.playSound(null, (Entity)player, SoundEvents.TOTEM_USE, SoundSource.PLAYERS, 1.0f, 0.9f + random.nextFloat() * 0.2f);
            relic.spreadRelicExperience((LivingEntity)player, stack, (Integer)stack.getOrDefault((Supplier)DataComponentRegistry.COUNT, (Object)1));
            player.setHealth(1.0f);
            event.setCanceled(true);
            stack.set((Supplier)DataComponentRegistry.TOGGLED, (Object)false);
            for (int i = 0; i < 50; ++i) {
                ((ServerLevel)level).sendParticles(ParticleUtils.constructSimpleSpark((Color)new Color(100 + random.nextInt(156), random.nextInt(100 + random.nextInt(156)), random.nextInt(100 + random.nextInt(156))), (float)0.5f, (int)60, (float)0.95f), player.getX(), player.getY() + 1.0, player.getZ(), 1, (random.nextDouble() - 0.5) * 3.0, random.nextDouble() * 1.5, (random.nextDouble() - 0.5) * 3.0, 0.05);
            }
        }
    }
}

