/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.client.gui;

import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.implementations.UpgradeableScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.ProgressBar;
import appeng.client.gui.widgets.ServerSettingToggleButton;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.menu.implementations.UpgradeableMenu;
import appeng.menu.interfaces.IProgressProvider;
import com.glodblock.github.extendedae.client.button.ActionEPPButton;
import com.glodblock.github.extendedae.client.button.EPPIcon;
import com.glodblock.github.extendedae.client.gui.subgui.OutputSideConfig;
import com.glodblock.github.extendedae.common.EAESingletons;
import com.glodblock.github.extendedae.container.ContainerCircuitCutter;
import com.glodblock.github.extendedae.network.EAENetworkHandler;
import com.glodblock.github.extendedae.network.packet.CEAEGenericPacket;
import com.glodblock.github.glodium.network.packet.IMessage;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class GuiCircuitCutter
extends UpgradeableScreen<ContainerCircuitCutter> {
    private final ProgressBar pb;
    private final SettingToggleButton<YesNo> autoExportBtn;
    private final ActionEPPButton outputSideBtn;

    public GuiCircuitCutter(ContainerCircuitCutter menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((UpgradeableMenu)menu, playerInventory, title, style);
        this.pb = new ProgressBar((IProgressProvider)this.menu, style.getImage("progressBar"), ProgressBar.Direction.VERTICAL);
        this.widgets.add("progressBar", (AbstractWidget)this.pb);
        this.autoExportBtn = new ServerSettingToggleButton(Settings.AUTO_EXPORT, (Enum)YesNo.NO);
        this.addToLeftToolbar((Button)this.autoExportBtn);
        this.outputSideBtn = new ActionEPPButton(b -> this.openOutputConfig(), EPPIcon.OUTPUT_SIDES);
        this.outputSideBtn.setMessage((Component)Component.translatable((String)"gui.extendedae.set_output_sides.open"));
        this.addToLeftToolbar((Button)this.outputSideBtn);
    }

    private void openOutputConfig() {
        if (((ContainerCircuitCutter)this.getMenu()).getHost() != null) {
            this.switchToScreen((AEBaseScreen)new OutputSideConfig(this, new ItemStack((ItemLike)EAESingletons.CIRCUIT_CUTTER), (AEBaseBlockEntity)((ContainerCircuitCutter)this.getMenu()).getHost(), ((ContainerCircuitCutter)this.getMenu()).getOutputSides(), (side, value) -> EAENetworkHandler.INSTANCE.sendToServer((IMessage)new CEAEGenericPacket("set_side", side.getName(), value))));
        }
    }

    protected void updateBeforeRender() {
        super.updateBeforeRender();
        int progress = ((ContainerCircuitCutter)this.menu).getCurrentProgress() * 100 / ((ContainerCircuitCutter)this.menu).getMaxProgress();
        this.pb.setFullMsg((Component)Component.literal((String)(progress + "%")));
        this.autoExportBtn.set((Enum)((ContainerCircuitCutter)this.getMenu()).getAutoExport());
        this.outputSideBtn.setVisibility(this.autoExportBtn.getCurrentValue() == YesNo.YES);
    }
}

