/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.client.gui.widget;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.MultilineTextField;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class MultilineTextFieldWidget
extends AbstractWidget {
    private Consumer<String> responder = s -> {};
    private Pattern filter = null;
    private int maxLength = Integer.MAX_VALUE;
    public static final int DEFAULT_MAX_LENGTH = Integer.MAX_VALUE;
    private final Font font;
    private final CachedTextField textField;
    private double scrollAmount;
    private boolean dragging;

    public MultilineTextFieldWidget(Font font, int x, int y, int w, int h, Component placeholder) {
        super(x, y, w, h, placeholder);
        this.font = font;
        this.textField = new CachedTextField(font, w - 4);
        this.textField.setCharacterLimit(Integer.MAX_VALUE);
        this.textField.setCursorListener(this::clampScroll);
        this.textField.setValueListener(v -> this.clampScroll());
        this.textField.setCursorListener(this::ensureCursorVisible);
    }

    public void setResponder(@NotNull Consumer<String> responder) {
        this.responder = responder;
    }

    public void setFilter(Pattern filter) {
        this.filter = filter;
        String cur = this.getValue();
        String s = this.sanitize(cur);
        if (!s.equals(cur)) {
            this.textField.setValue(s);
            this.onEdited();
        }
    }

    public void setMaxLength(int len) {
        this.maxLength = Math.max(0, len);
        String cur = this.getValue();
        if (cur.length() > this.maxLength) {
            this.textField.setValue(cur.substring(0, this.maxLength));
            this.onEdited();
        }
    }

    public String getValue() {
        return this.textField.value();
    }

    public void setValue(String v) {
        String s = this.sanitize(v);
        this.textField.setValue(s);
        this.onEdited();
    }

    public boolean keyPressed(int key, int sc, int mod) {
        boolean handled;
        if (!this.isFocused()) {
            return false;
        }
        if (key == 257 || key == 335) {
            this.textField.insertText("\n");
            this.clampScroll();
            this.ensureCursorVisible();
            this.sanitizeAndNotify();
            return true;
        }
        boolean bl = handled = this.textField.keyPressed(key) || Minecraft.getInstance().options.keyInventory.matches(key, sc);
        if (handled) {
            this.clampScroll();
            this.ensureCursorVisible();
            this.sanitizeAndNotify();
            return true;
        }
        return false;
    }

    public boolean charTyped(char chr, int mods) {
        if (!this.isFocused()) {
            return false;
        }
        if (chr == '\n' || chr == '\r') {
            return true;
        }
        if (this.filter != null && !this.filter.matcher(String.valueOf(chr)).matches()) {
            return true;
        }
        this.textField.insertText(String.valueOf(chr));
        this.clampScroll();
        this.ensureCursorVisible();
        this.sanitizeAndNotify();
        return true;
    }

    public boolean mouseClicked(double mx, double my, int btn) {
        if (!(this.isActive() && this.isValidClickButton(btn) && this.clicked(mx, my))) {
            return false;
        }
        this.setFocused(true);
        if (!Screen.hasShiftDown()) {
            this.textField.setSelecting(false);
        }
        this.moveCursorToMouse(mx, my);
        this.textField.setSelecting(true);
        this.dragging = true;
        return true;
    }

    public boolean mouseReleased(double mx, double my, int btn) {
        this.dragging = false;
        this.textField.setSelecting(false);
        return super.mouseReleased(mx, my, btn);
    }

    public boolean mouseDragged(double mx, double my, int btn, double dx, double dy) {
        if (this.dragging && this.isFocused()) {
            this.moveCursorToMouse(mx, my);
            return true;
        }
        return false;
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput narrationElementOutput) {
    }

    public boolean mouseScrolled(double mx, double my, double horizontal, double vertical) {
        if (!this.isMouseOver(mx, my)) {
            return false;
        }
        Objects.requireNonNull(this.font);
        this.setScrollAmount(this.scrollAmount - vertical * 9.0);
        return true;
    }

    public double getMaxScroll() {
        int n = this.textField.lineCount();
        Objects.requireNonNull(this.font);
        int textH = n * 9;
        return Math.max(textH - (this.height - 4), 0);
    }

    public void setScrollAmount(double a) {
        this.scrollAmount = Mth.clamp((double)a, (double)0.0, (double)this.getMaxScroll());
    }

    private void clampScroll() {
        this.setScrollAmount(this.scrollAmount);
    }

    private void ensureCursorVisible() {
        int viewH = this.height - 4;
        int caretLine = this.textField.lineAtCursor();
        Objects.requireNonNull(this.font);
        int caretY = caretLine * 9;
        double top = this.scrollAmount;
        double d = this.scrollAmount + (double)viewH;
        Objects.requireNonNull(this.font);
        double bottom = d - 9.0;
        if ((double)caretY < top) {
            this.setScrollAmount(caretY);
        } else if ((double)caretY > bottom) {
            Objects.requireNonNull(this.font);
            this.setScrollAmount(caretY - (viewH - 9));
        }
    }

    protected void renderWidget(GuiGraphics g, int mX, int mY, float partial) {
        Line ln;
        int bg = -14671840;
        int border = this.isFocused() ? -1 : -8355712;
        g.fill(RenderType.guiOverlay(), this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, bg);
        g.fill(RenderType.guiOverlay(), this.getX(), this.getY(), this.getX() + this.width, this.getY() + 1, border);
        g.fill(RenderType.guiOverlay(), this.getX(), this.getY() + this.height - 1, this.getX() + this.width, this.getY() + this.height, border);
        g.fill(RenderType.guiOverlay(), this.getX(), this.getY(), this.getX() + 1, this.getY() + this.height, border);
        g.fill(RenderType.guiOverlay(), this.getX() + this.width - 1, this.getY(), this.getX() + this.width, this.getY() + this.height, border);
        int clipL = this.getX() + 2;
        int clipT = this.getY() + 2;
        int clipR = this.getX() + this.width - 2;
        int clipB = this.getY() + this.height - 2;
        g.enableScissor(clipL, clipT, clipR, clipB);
        Objects.requireNonNull(this.font);
        int firstLine = (int)(this.scrollAmount / 9.0);
        int n = clipT - (int)this.scrollAmount;
        Objects.requireNonNull(this.font);
        int y = n + firstLine * 9;
        int selectionBegin = this.textField.hasSelection() ? this.textField.selection().begin() : -1;
        int selectionEnd = this.textField.hasSelection() ? this.textField.selection().end() : -1;
        int selectionColor = -2147450881;
        if (this.isFocused() && this.blink()) {
            int curLine = this.textField.lineAtCursor();
            ln = this.textField.line(curLine);
            int cx = clipL + this.font.width(this.textField.value().substring(ln.begin(), this.textField.cursor()));
            Objects.requireNonNull(this.font);
            int cy = clipT + curLine * 9 - (int)this.scrollAmount;
            if (cy >= clipT && cy < clipB) {
                RenderType renderType = RenderType.guiOverlay();
                Objects.requireNonNull(this.font);
                g.fill(renderType, cx, cy, cx + 1, cy + 9, -1);
            }
        }
        for (int idx = firstLine; idx < this.textField.lineCount() && y <= clipB; y += 9, ++idx) {
            ln = this.textField.line(idx);
            String str = this.textField.value().substring(ln.begin(), ln.end());
            int xOff = clipL;
            g.drawString(this.font, str, xOff, y, -2039584);
            if (this.textField.hasSelection()) {
                int selEndInLine;
                int selStartInLine;
                int lineStartChar = ln.begin();
                int lineEndChar = ln.end();
                if (selectionEnd > lineStartChar && selectionBegin < lineEndChar && (selStartInLine = Math.max(0, selectionBegin - lineStartChar)) < (selEndInLine = Math.min(str.length(), selectionEnd - lineStartChar))) {
                    String preSel = str.substring(0, selStartInLine);
                    String selectionText = str.substring(selStartInLine, selEndInLine);
                    int selX = xOff + this.font.width(preSel);
                    int selW = this.font.width(selectionText);
                    RenderType renderType = RenderType.guiTextHighlight();
                    Objects.requireNonNull(this.font);
                    g.fill(renderType, selX, y, selX + selW, y + 9, selectionColor);
                }
            }
            Objects.requireNonNull(this.font);
        }
        g.disableScissor();
        if (this.textField.value().isEmpty() && !this.isFocused()) {
            g.drawString(this.font, this.getMessage(), clipL, clipT, -8355712);
        }
    }

    private void sanitizeAndNotify() {
        String cur = this.getValue();
        String s = this.sanitize(cur);
        if (!s.equals(cur)) {
            this.textField.setValue(s);
        }
        this.onEdited();
    }

    private void onEdited() {
        try {
            this.responder.accept(this.getValue());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String sanitize(String in) {
        if (in == null) {
            return "";
        }
        StringBuilder b = new StringBuilder(in.length());
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (c == '\r') continue;
            if (c == '\n') {
                b.append('\n');
                continue;
            }
            if (this.filter != null && !this.filter.matcher(String.valueOf(c)).matches()) continue;
            b.append(c);
        }
        String s = b.toString();
        if (s.length() > this.maxLength) {
            s = s.substring(0, this.maxLength);
        }
        return s;
    }

    private void moveCursorToMouse(double mx, double my) {
        double relX = mx - (double)(this.getX() + 2);
        double relY = my - (double)(this.getY() + 2) + this.scrollAmount;
        this.textField.seekCursorToPoint(relX, relY);
    }

    private boolean blink() {
        return Util.getMillis() / 500L % 2L == 0L;
    }

    private static final class CachedTextField
    extends MultilineTextField {
        private List<Line> cache = new ArrayList<Line>();

        CachedTextField(Font font, int w) {
            super(font, w);
            this.rebuild();
        }

        int lineCount() {
            return this.cache.size();
        }

        Line line(int idx) {
            return this.cache.get(Mth.clamp((int)idx, (int)0, (int)(this.cache.size() - 1)));
        }

        int lineAtCursor() {
            return super.getLineAtCursor();
        }

        Selection selection() {
            MultilineTextField.StringView sv = super.getSelected();
            return new Selection(sv.beginIndex(), sv.endIndex());
        }

        public void setValue(@NotNull String v) {
            super.setValue(v);
            this.rebuild();
        }

        public void insertText(@NotNull String t) {
            super.insertText(t);
            this.rebuild();
        }

        private void rebuild() {
            if (this.cache == null) {
                this.cache = new ArrayList<Line>();
            }
            this.cache.clear();
            super.iterateLines().forEach(sv -> this.cache.add(new Line(sv.beginIndex(), sv.endIndex())));
        }

        record Selection(int begin, int end) {
        }
    }

    private record Line(int begin, int end) {
    }
}

