/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.items;

import appeng.api.config.FuzzyMode;
import appeng.api.ids.AEComponents;
import appeng.api.implementations.menuobjects.IMenuItem;
import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.api.storage.cells.ICellWorkbenchItem;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.items.AEBaseItem;
import appeng.items.contents.CellConfig;
import appeng.menu.MenuOpener;
import appeng.menu.locator.ItemMenuHostLocator;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.locator.MenuLocators;
import appeng.util.ConfigInventory;
import com.glodblock.github.extendedae.api.VoidMode;
import com.glodblock.github.extendedae.common.EAESingletons;
import com.glodblock.github.extendedae.common.inventory.VoidCellInventory;
import com.glodblock.github.extendedae.container.ContainerVoidCell;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemVoidCell
extends AEBaseItem
implements ICellWorkbenchItem,
IMenuItem {
    public ItemVoidCell() {
        super(new Item.Properties().stacksTo(1));
    }

    public void appendHoverText(@NotNull ItemStack is, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Item.TooltipContext ctx, @NotNull List<Component> lines, @NotNull TooltipFlag adv) {
        VoidCellInventory inv = (VoidCellInventory)VoidCellInventory.HANDLER.getCellInventory(is, null);
        VoidMode mode = (VoidMode)((Object)is.getOrDefault(EAESingletons.VOID_MODE, (Object)VoidMode.TRASH));
        lines.add((Component)Component.translatable((String)("gui.extendedae.void_cell.mode." + mode.ordinal())).withStyle(ChatFormatting.GREEN));
        if (inv == null || !inv.isPartitioned()) {
            lines.add((Component)Component.translatable((String)"void_warn.tooltip").withStyle(ChatFormatting.RED));
        }
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack is) {
        VoidCellInventory inv = (VoidCellInventory)VoidCellInventory.HANDLER.getCellInventory(is, null);
        if (inv != null) {
            return inv.getTooltipImage();
        }
        return Optional.empty();
    }

    public IUpgradeInventory getUpgrades(ItemStack is) {
        return UpgradeInventories.forItem((ItemStack)is, (int)2);
    }

    public ConfigInventory getConfigInventory(ItemStack is) {
        return CellConfig.create((ItemStack)is);
    }

    public FuzzyMode getFuzzyMode(ItemStack is) {
        return (FuzzyMode)is.getOrDefault(AEComponents.STORAGE_CELL_FUZZY_MODE, (Object)FuzzyMode.IGNORE_ALL);
    }

    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        is.set(AEComponents.STORAGE_CELL_FUZZY_MODE, (Object)fzMode);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player p, @NotNull InteractionHand hand) {
        if (!level.isClientSide()) {
            MenuOpener.open(ContainerVoidCell.TYPE, (Player)p, (MenuHostLocator)MenuLocators.forHand((Player)p, (InteractionHand)hand));
        }
        return new InteractionResultHolder(InteractionResult.sidedSuccess((boolean)level.isClientSide()), (Object)p.getItemInHand(hand));
    }

    @Nullable
    public ItemMenuHost<ItemVoidCell> getMenuHost(Player player, ItemMenuHostLocator locator, @Nullable BlockHitResult hitResult) {
        return new ItemMenuHost((Item)this, player, locator);
    }
}

