/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.access;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.level.block.entity.vault.VaultState;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import snownee.jade.addon.access.AccessibilityPlugin;
import snownee.jade.addon.core.ObjectNameProvider;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;

public class BlockDetailsProvider
implements IBlockComponentProvider {
    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        BlockState blockState = accessor.getBlockState();
        Block block = blockState.getBlock();
        if (blockState.hasProperty((Property)BlockStateProperties.OPEN) && !(block instanceof BarrelBlock)) {
            AccessibilityPlugin.replaceTitle(tooltip, "block.door_" + ((Boolean)blockState.getValue((Property)BlockStateProperties.OPEN) != false ? "open" : "closed"));
        }
        if (blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && ((Boolean)blockState.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            AccessibilityPlugin.replaceTitle(tooltip, "block.waterlogged");
        }
        if (blockState.hasProperty((Property)BlockStateProperties.LIT) && ((Boolean)blockState.getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
            AccessibilityPlugin.replaceTitle(tooltip, "block.lit");
        }
        if (blockState.hasProperty((Property)BlockStateProperties.INVERTED) && ((Boolean)blockState.getValue((Property)BlockStateProperties.INVERTED)).booleanValue()) {
            AccessibilityPlugin.replaceTitle(tooltip, "block.inverted");
        }
        if (blockState.hasProperty((Property)BlockStateProperties.EYE) && ((Boolean)blockState.getValue((Property)BlockStateProperties.EYE)).booleanValue()) {
            AccessibilityPlugin.replaceTitle(tooltip, "block.eye");
        }
        if (blockState.hasProperty((Property)BlockStateProperties.OMINOUS) && ((Boolean)blockState.getValue((Property)BlockStateProperties.OMINOUS)).booleanValue()) {
            AccessibilityPlugin.replaceTitle(tooltip, "block.ominous");
        }
        if (blockState.hasProperty((Property)BlockStateProperties.MOISTURE) && (Integer)blockState.getValue((Property)BlockStateProperties.MOISTURE) == 7) {
            AccessibilityPlugin.replaceTitle(tooltip, "block.hydrated");
        }
        if (blockState.hasProperty((Property)BlockStateProperties.LOCKED) && ((Boolean)blockState.getValue((Property)BlockStateProperties.LOCKED)).booleanValue()) {
            AccessibilityPlugin.replaceTitle(tooltip, "block.locked");
        }
        if (blockState.hasProperty((Property)BlockStateProperties.EXTENDED) && ((Boolean)blockState.getValue((Property)BlockStateProperties.EXTENDED)).booleanValue()) {
            AccessibilityPlugin.replaceTitle(tooltip, "block.extended");
        }
        if (blockState.hasProperty((Property)BlockStateProperties.CAN_SUMMON) && ((Boolean)blockState.getValue((Property)BlockStateProperties.CAN_SUMMON)).booleanValue()) {
            AccessibilityPlugin.replaceTitle(tooltip, "block.summonable");
        }
        if (blockState.hasProperty((Property)BlockStateProperties.HATCH)) {
            int i = (Integer)blockState.getValue((Property)BlockStateProperties.HATCH);
            if (i == 1) {
                AccessibilityPlugin.replaceTitle(tooltip, "block.hatch.1");
            } else if (i == 2) {
                AccessibilityPlugin.replaceTitle(tooltip, "block.hatch.2");
            }
        }
        if (blockState.hasProperty((Property)BlockStateProperties.POWERED) && ((Boolean)blockState.getValue((Property)BlockStateProperties.POWERED)).booleanValue() && (block instanceof RepeaterBlock || block instanceof BaseRailBlock)) {
            AccessibilityPlugin.replaceTitle(tooltip, "block.powered");
        }
        boolean active = false;
        if (blockState.hasProperty((Property)BlockStateProperties.VAULT_STATE) && blockState.getValue((Property)BlockStateProperties.VAULT_STATE) == VaultState.ACTIVE) {
            active = true;
        } else if (blockState.hasProperty((Property)BlockStateProperties.TRIAL_SPAWNER_STATE) && blockState.getValue((Property)BlockStateProperties.TRIAL_SPAWNER_STATE) == TrialSpawnerState.ACTIVE) {
            active = true;
        }
        if (active) {
            AccessibilityPlugin.replaceTitle(tooltip, "block.active");
        }
    }

    @Override
    public ResourceLocation getUid() {
        return JadeIds.ACCESS_BLOCK_DETAILS;
    }

    @Override
    public int getDefaultPriority() {
        return ObjectNameProvider.getBlock().getDefaultPriority() + 10;
    }
}

