/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.config.data;

import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import net.bivrik.fancytoasts.client.config.ConfigHandler;
import net.bivrik.fancytoasts.client.config.data.ConfigData;
import net.bivrik.fancytoasts.client.registry.AnimationRegistry;
import net.bivrik.fancytoasts.client.registry.TextureRegistry;
import net.bivrik.fancytoasts.platform.utility.FancyToastType;
import net.bivrik.fancytoasts.utility.DefaultLocations;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;

public class ToastConfigData
extends ConfigData {
    private ResourceLocation textureId;
    private ResourceLocation animationId;
    private final Map<FancyToastType, ResourceLocation> soundIds = new EnumMap<FancyToastType, ResourceLocation>(FancyToastType.class);

    public ToastConfigData(ResourceLocation textureId, ResourceLocation animationId, Map<FancyToastType, ResourceLocation> soundIds) {
        super("./config/fancytoasts/toast.json");
        this.textureId = textureId;
        this.animationId = animationId;
        this.soundIds.putAll(soundIds);
    }

    public ToastConfigData() {
        this(DefaultLocations.Textures.VANILLA, DefaultLocations.Animations.STANDARD, Map.of(FancyToastType.TASK, SoundEvents.ALLAY_AMBIENT_WITH_ITEM.getLocation(), FancyToastType.GOAL, SoundEvents.FIREWORK_ROCKET_TWINKLE_FAR.getLocation(), FancyToastType.CHALLENGE, SoundEvents.UI_TOAST_CHALLENGE_COMPLETE.getLocation()));
    }

    public ResourceLocation getTextureId() {
        if (this.isConfig(this.textureId) && !TextureRegistry.isRegistered(this.textureId)) {
            ResourceLocation standardTextureId = new ToastConfigData().textureId;
            this.setTextureId(standardTextureId);
            ConfigHandler.save(this.copy());
            return standardTextureId;
        }
        return this.textureId;
    }

    public void setTextureId(ResourceLocation id) {
        this.textureId = id;
    }

    public ResourceLocation getAnimationId() {
        return this.animationId;
    }

    public void setAnimationId(ResourceLocation id) {
        this.animationId = id;
    }

    public ResourceLocation getSoundIdByType(FancyToastType type) {
        ResourceLocation soundId;
        Collection availableSounds = Minecraft.getInstance().getSoundManager().getAvailableSounds();
        if (!availableSounds.contains(soundId = this.soundIds.get((Object)type))) {
            ResourceLocation standardSoundId = new ToastConfigData().soundIds.get((Object)type);
            this.putSoundIdForType(standardSoundId, type);
            ConfigHandler.save(this.copy());
            return standardSoundId;
        }
        return this.soundIds.get((Object)type);
    }

    public void putSoundIdForType(ResourceLocation location, FancyToastType type) {
        this.soundIds.put(type, location);
    }

    @Override
    public boolean isValid() {
        boolean isValid = true;
        if (!this.isConfig(this.animationId)) {
            isValid = AnimationRegistry.isRegistered(this.animationId);
        }
        if (!this.isConfig(this.textureId)) {
            isValid = isValid && TextureRegistry.isRegistered(this.textureId);
        }
        return isValid;
    }

    private boolean isConfig(ResourceLocation id) {
        return id.toLanguageKey().contains("config");
    }

    public boolean equals(Object o) {
        if (!(o instanceof ToastConfigData)) {
            return false;
        }
        ToastConfigData that = (ToastConfigData)o;
        return Objects.equals(this.textureId, that.textureId) && Objects.equals(this.animationId, that.animationId) && Objects.equals(this.soundIds, that.soundIds);
    }

    public int hashCode() {
        return Objects.hash(this.textureId, this.animationId, this.soundIds);
    }

    @Override
    public ToastConfigData copy() {
        return new ToastConfigData(this.textureId, this.animationId, this.soundIds);
    }

    @Override
    public String toString() {
        return super.toString().replace("}", ", ") + String.format("textureId='%s', animationId='%s', soundIds='%s'}", this.textureId, this.animationId, this.soundIds);
    }
}

