/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.gui;

import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;

public class Slider
extends AbstractSliderButton {
    private final Component label;
    private final double min;
    private final double max;
    private final float threshold;
    private boolean isPressed;
    private Function<Float, Component> displayer;
    private Consumer<Float> responder;

    public Slider(int x, int y, int width, int height, Component label, float value, float min, float max, float threshold) {
        super(x, y, width, height, (Component)Component.empty(), (double)(value / max));
        this.label = label;
        this.min = min;
        this.max = max;
        this.threshold = threshold;
        this.updateMessage();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean clicked = super.mouseClicked(mouseX, mouseY, button);
        if (clicked) {
            this.isPressed = true;
        }
        return clicked;
    }

    public void onRelease(double mouseX, double mouseY) {
        if (this.isPressed) {
            this.playSound(Minecraft.getInstance().getSoundManager());
        }
        this.isPressed = false;
    }

    private void playSound(SoundManager soundManager) {
        soundManager.play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
    }

    public Slider(int x, int y, int width, int height, Component label, float value, float max, float threshold) {
        this(x, y, width, height, label, value, 0.0f, max, threshold);
    }

    public Slider setResponder(Consumer<Float> responder) {
        this.responder = responder;
        return this;
    }

    public Slider setDisplayer(Function<Float, Component> displayer) {
        this.displayer = displayer;
        this.updateMessage();
        return this;
    }

    private float getValue() {
        float value = (float)Math.round(Mth.lerp((double)this.value, (double)this.min, (double)this.max) * 100.0) / 100.0f;
        int intValue = Math.round(value);
        if (this.threshold != 0.0f && value >= (float)intValue - this.threshold && value <= (float)intValue + this.threshold) {
            return intValue;
        }
        return value;
    }

    protected void updateMessage() {
        if (this.displayer == null) {
            this.displayer = value -> Component.literal((String)value.toString());
        }
        this.setMessage((Component)CommonComponents.optionNameValue((Component)this.label, (Component)this.displayer.apply(Float.valueOf(this.getValue()))));
    }

    protected void applyValue() {
        if (this.responder == null) {
            return;
        }
        this.responder.accept(Float.valueOf(this.getValue()));
    }
}

