/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.bivrik.fancytoasts.client.config.ConfigHandler;
import net.bivrik.fancytoasts.client.config.data.ToastsFilteringData;
import net.bivrik.fancytoasts.client.gui.screen.UniversalScreen;
import net.bivrik.fancytoasts.client.toast.Appearance;
import net.bivrik.fancytoasts.core.Managers;
import net.bivrik.fancytoasts.core.event.ToastsFilteringDataEvent;
import net.bivrik.fancytoasts.platform.Services;
import net.bivrik.fancytoasts.platform.utility.Colors;
import net.bivrik.fancytoasts.platform.utility.Components;
import net.bivrik.fancytoasts.platform.utility.GuiContext;
import net.bivrik.fancytoasts.platform.utility.ResourceLocations;
import net.bivrik.fancytoasts.utility.MathEasing;
import net.bivrik.fancytoasts.utility.TextureUV;
import net.bivrik.fancytoasts.utility.file.Paths;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ToastsFilteringScreen
extends UniversalScreen {
    private static final Component TITLE = Components.of("title.toasts_filtering");
    private static final Component RESET_TOASTS_FILTERING_TITLE = Components.of("title.reset_toasts_filtering");
    private static final Component RESET_TOASTS_FILTERING_LABEL = Components.of("label.reset_toasts_filtering");
    private static final Component SAVED_LABEL = Components.of("label.saved");
    private static final Component RESET = Components.of("gui.reset");
    private static final Component FANCY_ADVANCEMENT_TOASTS = Components.of("gui.fancy_advancement_toasts");
    private static final Component ADVANCEMENT_TOASTS = Components.of("gui.advancement_toasts");
    private static final Component FANCY_QUEST_TOASTS = Components.of("gui.fancy_quest_toasts");
    private static final Component RECIPE_TOASTS = Components.of("gui.recipe_toasts");
    private static final Component SYSTEM_TOASTS = Components.of("gui.system_toasts");
    private static final Component TUTORIAL_TOASTS = Components.of("gui.tutorial_toasts");
    private static final Component IGNORED_TOASTS = Components.of("gui.ignored_toasts");
    private static final Component TOASTS_FILTERING_TOOLTIP = Components.of("tooltip.toasts_filtering");
    private static final ResourceLocation LIST_BACKGROUND = ResourceLocations.fromMinecraft("textures/gui/menu_list_background.png");
    private ToastsFilteringData toastsFilteringData = Managers.getConfigManager().getToastsFilteringData();
    private boolean isSaved;
    private long savedFeedbackStartTime;
    private Button doneButton;
    private Button backButton;
    private Button resetButton;
    private Button toastsFilteringFileButton;
    private CycleButton<Boolean> fancyAdvancementToastsButton;
    private CycleButton<Boolean> fancyQuestToastsButton;
    private CycleButton<Boolean> advancementToastsButton;
    private CycleButton<Boolean> recipeToastsButton;
    private CycleButton<Boolean> systemToastsButton;
    private CycleButton<Boolean> tutorialToastsButton;

    public ToastsFilteringScreen(Screen parent) {
        super(TITLE, parent);
    }

    protected void init() {
        int xCenter = this.width / 2;
        this.backButton = this.addFWidget(this.createButton(CommonComponents.GUI_BACK, button -> this.toParentScreen(), xCenter - 125 - 4, this.height - 20 - 6, 75, 20));
        this.resetButton = this.addFWidget(this.createButton(RESET, button -> this.confirmResetting(), xCenter - 50, this.height - 20 - 6, 50, 20));
        this.doneButton = this.addFWidget(this.createButton(CommonComponents.GUI_DONE, button -> this.done(), xCenter + 4, this.height - 20 - 6, 125, 20));
        ListHelper listHelper = new ListHelper(this);
        this.fancyAdvancementToastsButton = listHelper.addWidget(this.createBooleanButton(FANCY_ADVANCEMENT_TOASTS, this.toastsFilteringData.isFancyAdvancementToastsEnabled(), (CycleButton.OnValueChange<Boolean>)((CycleButton.OnValueChange)(button, value) -> this.toastsFilteringData.setFancyAdvancementToastsEnabled((boolean)value)), 0, 0));
        if (Services.PLATFORM.isModLoaded("ftbquests")) {
            this.fancyQuestToastsButton = listHelper.addWidget(this.createBooleanButton(FANCY_QUEST_TOASTS, this.toastsFilteringData.isFancyQuestToastsEnabled(), (CycleButton.OnValueChange<Boolean>)((CycleButton.OnValueChange)(button, value) -> this.toastsFilteringData.setFancyQuestToastsEnabled((boolean)value)), 0, 0));
        }
        this.advancementToastsButton = listHelper.addWidget(this.createBooleanButton(ADVANCEMENT_TOASTS, this.toastsFilteringData.isAdvancementToastsEnabled(), (CycleButton.OnValueChange<Boolean>)((CycleButton.OnValueChange)(button, value) -> this.toastsFilteringData.setAdvancementToastsEnabled((boolean)value)), 0, 0));
        this.recipeToastsButton = listHelper.addWidget(this.createBooleanButton(RECIPE_TOASTS, this.toastsFilteringData.isRecipeToastsEnabled(), (CycleButton.OnValueChange<Boolean>)((CycleButton.OnValueChange)(button, value) -> this.toastsFilteringData.setRecipeToastsEnabled((boolean)value)), 0, 0));
        this.systemToastsButton = listHelper.addWidget(this.createBooleanButton(SYSTEM_TOASTS, this.toastsFilteringData.isSystemToastsEnabled(), (CycleButton.OnValueChange<Boolean>)((CycleButton.OnValueChange)(button, value) -> this.toastsFilteringData.setSystemToastsEnabled((boolean)value)), 0, 0));
        this.tutorialToastsButton = listHelper.addWidget(this.createBooleanButton(TUTORIAL_TOASTS, this.toastsFilteringData.isTutorialToastsEnabled(), (CycleButton.OnValueChange<Boolean>)((CycleButton.OnValueChange)(button, value) -> this.toastsFilteringData.setTutorialToastsEnabled((boolean)value)), 0, 0));
        this.toastsFilteringFileButton = listHelper.addWidget(this.createButton(IGNORED_TOASTS, button -> this.openToastsFilteringFile(), 0, 0, Tooltip.create((Component)TOASTS_FILTERING_TOOLTIP)));
        listHelper.arrangeWidgets();
        listHelper.visitWidgets(this::addFWidget);
    }

    private void openToastsFilteringFile() {
        Util.getPlatform().openPath(Paths.actualPath("./config/fancytoasts/toast_filtering.json"));
    }

    private void confirmResetting() {
        this.openScreen((Screen)new ConfirmScreen(this::reset, RESET_TOASTS_FILTERING_TITLE, RESET_TOASTS_FILTERING_LABEL));
    }

    private void reset(boolean isConfirmed) {
        this.openScreen(this);
        if (!isConfirmed) {
            return;
        }
        this.toastsFilteringData = new ToastsFilteringData();
        this.save(this.toastsFilteringData.copy());
        this.rebuildWidgets();
    }

    private void done() {
        ToastsFilteringData data = this.toastsFilteringData.copy();
        if (!data.equals(Managers.getConfigManager().getToastsFilteringData())) {
            this.save(data);
        } else {
            this.toParentScreen();
        }
    }

    private void save(ToastsFilteringData data) {
        ConfigHandler.save(data);
        Managers.getEventManager().changed(new ToastsFilteringDataEvent(data));
        this.isSaved = true;
        this.savedFeedbackStartTime = Util.getMillis();
    }

    @Override
    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        this.drawTitle(guiGraphics);
        this.drawListBackground(guiGraphics);
        this.drawRenderables(guiGraphics, mouseX, mouseY, partialTick);
        this.drawSavedFeedback(guiGraphics, this.width / 2 + 8 - 25 + 150, this.height - 20);
    }

    private void drawSavedFeedback(GuiGraphics guiGraphics, int x, int y) {
        if (!this.isSaved) {
            return;
        }
        long time = Util.getMillis() - this.savedFeedbackStartTime;
        float appearanceLerp = MathEasing.easeOutLerp(0.0f, 1.0f, Appearance.getProgress(time, 500, 0));
        float disappearanceLerp = Appearance.getProgress(time, 500, 400);
        int color = Colors.alpha(appearanceLerp - disappearanceLerp, -256);
        guiGraphics.drawString(this.font, SAVED_LABEL, x, y, color);
        if (time > 850L) {
            this.isSaved = false;
        }
    }

    private void drawListBackground(GuiGraphics guiGraphics) {
        GuiContext context = new GuiContext(guiGraphics);
        RenderSystem.enableBlend();
        context.drawGUITexture(LIST_BACKGROUND, 0, 32, this.width, this.height - 64 - 2, TextureUV.ZERO, 32, 32);
        context.drawGUITexture(Screen.HEADER_SEPARATOR, 0, 32, this.width, 2, TextureUV.ZERO, 32, 2);
        context.drawGUITexture(Screen.FOOTER_SEPARATOR, 0, this.height - 32 - 2, this.width, 2, TextureUV.ZERO, 32, 2);
        RenderSystem.disableBlend();
    }

    private static class ListHelper {
        private final List<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
        private final Screen parentScreen;

        private ListHelper(Screen parentScreen) {
            this.parentScreen = parentScreen;
        }

        public <T extends AbstractWidget> T addWidget(T widget) {
            this.widgets.add(widget);
            return widget;
        }

        public void arrangeWidgets() {
            int y = 40;
            int xCenter = this.parentScreen.width / 2;
            for (int i = 0; i < this.widgets.size(); ++i) {
                int x = xCenter;
                if ((i & 1) == 0) {
                    if (i != 0) {
                        y += 28;
                    }
                    x -= 154;
                } else {
                    x += 4;
                }
                this.widgets.get(i).setPosition(x, y);
            }
        }

        public void visitWidgets(Consumer<AbstractWidget> widgetConsumer) {
            this.widgets.forEach(widgetConsumer);
        }
    }
}

