/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.toast.animation;

import net.bivrik.fancytoasts.client.toast.AnimationSetup;
import net.bivrik.fancytoasts.client.toast.Appearance;
import net.bivrik.fancytoasts.client.toast.animation.FancyToastAnimation;
import net.bivrik.fancytoasts.platform.utility.GuiContext;
import net.bivrik.fancytoasts.utility.MathEasing;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;

public class OldlikeAnimation
extends FancyToastAnimation {
    private final Appearance ICON_APPEARANCE = new Appearance(2000, 0);
    private final Appearance BANNER_APPEARANCE = new Appearance(2000, 100);
    private final Appearance BACKGROUND_APPEARANCE = new Appearance(2000, 200);
    private final Appearance TITLE_TEXT_APPEARANCE = new Appearance(2000, 1200);
    private final Appearance DESCRIPTION_TEXT_APPEARANCE = new Appearance(2000, 1400);
    private final int FADE_OUT_DURATION = 3000;
    private final int DURATION = 6500;

    @Override
    public void setup(AnimationSetup setup, Minecraft minecraft, int toastWidth, int toastHeight) {
        super.setup(setup, minecraft, toastWidth, toastHeight);
        this.setLines(this.displayInfo.getAnnouncement(), this.displayInfo.getDescription());
    }

    @Override
    public void draw(GuiGraphics guiGraphics, long time) {
        float x;
        float alpha;
        super.draw(guiGraphics, time);
        float iconAppearProgress = this.ICON_APPEARANCE.getProgress(time);
        float bannerAppearProgress = this.BANNER_APPEARANCE.getProgress(time);
        float backgroundAppearProgress = this.BACKGROUND_APPEARANCE.getProgress(time);
        float titleAppearProgress = this.TITLE_TEXT_APPEARANCE.getProgress(time);
        float descriptionAppearProgress = this.DESCRIPTION_TEXT_APPEARANCE.getProgress(time);
        float fadeOutProgress = Appearance.getProgress(time, 3000, 3500);
        GuiContext context = new GuiContext(guiGraphics);
        if (bannerAppearProgress > 0.0f) {
            context.push();
            alpha = 1.0f;
            if (bannerAppearProgress != 1.0f) {
                alpha = MathEasing.easeOutLerp(0.0f, 1.0f, bannerAppearProgress);
                x = MathEasing.easeOutLerp(35.0f, 0.0f, bannerAppearProgress);
                context.translate(x, 0.0f);
            } else if (fadeOutProgress != 1.0f && fadeOutProgress > 0.0f) {
                alpha = MathEasing.easeInLerp(1.0f, 0.0f, fadeOutProgress);
            }
            float sinY = this.sinusoidLoop(time, 1.14f, 2.0f);
            context.translate(0.0f, sinY + 5.0f);
            this.drawBanner(context, alpha);
            context.pop();
        }
        if (backgroundAppearProgress > 0.0f) {
            context.push();
            alpha = 1.0f;
            if (backgroundAppearProgress != 1.0f) {
                alpha = MathEasing.easeOutLerp(0.0f, 1.0f, backgroundAppearProgress);
                x = MathEasing.easeOutLerp(35.0f, 0.0f, backgroundAppearProgress);
                context.translate(x, 0.0f);
            } else if (fadeOutProgress != 1.0f && fadeOutProgress > 0.0f) {
                alpha = MathEasing.easeInLerp(1.0f, 0.0f, fadeOutProgress);
            }
            this.drawBackground(context, alpha);
            context.pop();
        }
        if (iconAppearProgress > 0.0f) {
            context.push();
            alpha = 1.0f;
            int x2 = 77;
            float scale = 1.0f;
            if (iconAppearProgress != 1.0f) {
                alpha = MathEasing.easeOutLerp(0.0f, 1.0f, iconAppearProgress);
                x2 = MathEasing.easeOutLerp(115, 77, iconAppearProgress);
            } else if (fadeOutProgress != 1.0f && fadeOutProgress > 0.0f) {
                alpha = MathEasing.easeInLerp(1.0f, 0.0f, fadeOutProgress);
                scale = MathEasing.easeInLerp(1.0f, 0.0f, fadeOutProgress);
            }
            context.translate(x2, 11.0f);
            context.scaleAround(scale, 81.0f, 14.0f);
            float cosRotation = this.cosineLoop(time, 1.6f, 0.2f);
            context.rotateAround(cosRotation, 81.0f, 14.0f);
            this.drawIcon(context, alpha);
            context.pop();
        }
        float fadeOutTextAlpha = 0.0f;
        if (fadeOutProgress != 1.0f && fadeOutProgress > 0.0f) {
            fadeOutTextAlpha = MathEasing.easeInLerp(0.0f, 1.0f, fadeOutProgress);
        }
        if (titleAppearProgress > 0.05f) {
            context.push();
            if (titleAppearProgress != 1.0f) {
                int x3 = MathEasing.elasticEaseOutLerp(50, 0, titleAppearProgress);
                context.translate(x3, 0.0f);
            }
            this.drawTitle(guiGraphics, titleAppearProgress - fadeOutTextAlpha);
            context.pop();
        }
        if (descriptionAppearProgress > 0.05f) {
            context.push();
            if (descriptionAppearProgress != 1.0f) {
                int x4 = MathEasing.elasticEaseOutLerp(50, 0, descriptionAppearProgress);
                context.translate(x4, 0.0f);
            }
            this.drawDescription(guiGraphics, descriptionAppearProgress - fadeOutTextAlpha);
            context.pop();
        }
    }

    @Override
    public int getDuration() {
        return 6475;
    }

    @Override
    public int getToastSoundTiming() {
        return this.TITLE_TEXT_APPEARANCE.startPoint() + 280;
    }
}

