/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.toast.animation;

import java.util.List;
import net.bivrik.fancytoasts.client.toast.AnimationSetup;
import net.bivrik.fancytoasts.client.toast.Appearance;
import net.bivrik.fancytoasts.client.toast.animation.FancyToastAnimation;
import net.bivrik.fancytoasts.platform.utility.Colors;
import net.bivrik.fancytoasts.platform.utility.GuiContext;
import net.bivrik.fancytoasts.utility.MathEasing;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.FormattedCharSequence;

public class StandardAnimation
extends FancyToastAnimation {
    private final Appearance ICON_APPEARANCE = new Appearance(2000, 0);
    private final Appearance BANNER_APPEARANCE = new Appearance(500, 1500);
    private final Appearance BACKGROUND_APPEARANCE = new Appearance(800, 1600);
    private final Appearance TEXT_APPEARANCE = new Appearance(1000, 2000);
    private final int FADE_OUT_DURATION = 2000;
    private final int DURATION = 8000;

    @Override
    public void setup(AnimationSetup setup, Minecraft minecraft, int toastWidth, int toastHeight) {
        super.setup(setup, minecraft, toastWidth, toastHeight);
        this.setLines(this.displayInfo.getAnnouncement(), this.displayInfo.getTitle());
    }

    @Override
    public void draw(GuiGraphics guiGraphics, long time) {
        super.draw(guiGraphics, time);
        float iconAppearProgress = this.ICON_APPEARANCE.getProgress(time);
        float bannerAppearProgress = this.BANNER_APPEARANCE.getProgress(time);
        float backgroundAppearProgress = this.BACKGROUND_APPEARANCE.getProgress(time);
        float textAppearProgress = this.TEXT_APPEARANCE.getProgress(time);
        float fadeOutProgress = Appearance.getProgress(time, 2000, 6000);
        GuiContext context = new GuiContext(guiGraphics);
        if (fadeOutProgress > 0.0f) {
            float fadeOutY = MathEasing.easeInLerp(0.0f, -80.0f, fadeOutProgress);
            context.push();
            context.translate(0.0f, fadeOutY);
        }
        if (backgroundAppearProgress > 0.0f) {
            context.push();
            if (backgroundAppearProgress != 1.0f) {
                float y = MathEasing.easeOutLerp(-200.0f, 0.0f, backgroundAppearProgress);
                context.translate(0.0f, y);
            }
            this.drawBackground(context);
            context.pop();
        }
        if (bannerAppearProgress > 0.0f) {
            context.push();
            if (bannerAppearProgress != 1.0f) {
                float xScale = MathEasing.easeOutLerp(0.0f, 1.0f, bannerAppearProgress);
                context.scaleAround(xScale, 1.0f, 81.0f, 0.0f);
            }
            this.drawBanner(context);
            context.pop();
        }
        if (iconAppearProgress > 0.0f) {
            context.push();
            if (iconAppearProgress != 1.0f) {
                float scale = MathEasing.easeOutLerp(0.0f, 1.0f, iconAppearProgress);
                context.scaleAround(scale, 81.0f, 13.0f);
                float y = MathEasing.easeOutLerp(-100.0f, 0.0f, iconAppearProgress);
                context.translate(0.0f, y);
            }
            float sinY = this.sinusoidLoop(time, 1.6f, 1.5f);
            context.translate(0.0f, sinY - 5.0f);
            this.drawIcon(context);
            context.pop();
        }
        if (textAppearProgress > 0.05f) {
            this.drawTitle(guiGraphics, textAppearProgress);
            this.drawDescription(guiGraphics, textAppearProgress);
        }
        if (fadeOutProgress > 0.0f) {
            context.pop();
        }
    }

    @Override
    protected void drawDescription(GuiGraphics guiGraphics, float alpha) {
        List<FormattedCharSequence> descriptionLines = this.getDescriptionLines();
        if (descriptionLines.isEmpty()) {
            return;
        }
        int centerToastX = this.toastWidth / 2;
        int descriptionColor = Colors.alpha(alpha, this.displayInfo.getAdvancementType().getSecondaryColor());
        if (descriptionLines.size() == 1) {
            guiGraphics.drawCenteredString(this.minecraft.font, descriptionLines.getFirst(), centerToastX, 43, descriptionColor);
        } else {
            int lineHeight = 42 - 9 * (descriptionLines.size() - 1) / 2;
            for (FormattedCharSequence line : descriptionLines) {
                guiGraphics.drawCenteredString(this.minecraft.font, line, centerToastX, lineHeight, descriptionColor);
                lineHeight += 9;
            }
        }
    }

    @Override
    public int getDuration() {
        return 8000;
    }

    @Override
    public int getToastSoundTiming() {
        return this.TEXT_APPEARANCE.startPoint() + 180;
    }
}

