/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.platform;

import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import net.bivrik.fancytoasts.core.Debug;
import net.bivrik.fancytoasts.platform.services.IFTBQuestsHelper;
import net.bivrik.fancytoasts.platform.services.IJadeHelper;
import net.bivrik.fancytoasts.platform.services.IPlatformHelper;
import org.slf4j.Logger;

public class Services {
    private static final Logger LOGGER = Debug.getLogger(Services.class);
    public static final IPlatformHelper PLATFORM = Services.load(IPlatformHelper.class);
    private static final Map<Class<?>, Supplier<?>> FALLBACKS = Map.of(IJadeHelper.class, () -> new IJadeHelper(){}, IFTBQuestsHelper.class, () -> new IFTBQuestsHelper(){});
    public static final IJadeHelper JADE = Services.loadOptional(IJadeHelper.class);
    public static final IFTBQuestsHelper FTB_QUESTS = Services.loadOptional(IFTBQuestsHelper.class);

    public static <T> T load(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        LOGGER.info("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }

    public static <T> T loadOptional(Class<T> clazz) {
        try {
            return Services.load(clazz);
        }
        catch (NullPointerException e) {
            Supplier<?> fallback = FALLBACKS.get(clazz);
            if (fallback == null) {
                throw new RuntimeException("No service implementation of fallback found for optional " + String.valueOf(clazz));
            }
            Object result = fallback.get();
            LOGGER.info("Loaded fallback {} for service {}", result, clazz);
            return (T)result;
        }
    }
}

