/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.utility;

public class MathEasing {
    private static float easeOut(float t) {
        return (float)(1.0 - Math.pow(1.0f - t, 8.0));
    }

    private static float easeIn(float t) {
        return (float)Math.pow(t, 8.0);
    }

    private static float easeInOut(float t) {
        return (float)(Math.pow(t, 2.0) * (double)(3.0f - 2.0f * t));
    }

    private static float elasticEaseOut(float t) {
        return (float)(1.0 - Math.pow(2.0, -10.0f * t) * Math.cos((double)t * Math.PI * 4.0));
    }

    public static float easeOutLerp(float start, float end, float t) {
        return start + (end - start) * MathEasing.easeOut(t);
    }

    public static int easeOutLerp(int start, int end, float t) {
        return (int)((float)start + (float)(end - start) * MathEasing.easeOut(t));
    }

    public static float easeInLerp(float start, float end, float t) {
        return start + (end - start) * MathEasing.easeIn(t);
    }

    public static int easeInLerp(int start, int end, float t) {
        return (int)((float)start + (float)(end - start) * MathEasing.easeIn(t));
    }

    public static float easeInOutLerp(float start, float end, float t) {
        return start + (end - start) * MathEasing.easeInOut(t);
    }

    public static int easeInOutLerp(int start, int end, float t) {
        return (int)((float)start + (float)(end - start) * MathEasing.easeInOut(t));
    }

    public static float elasticEaseOutLerp(float start, float end, float t) {
        return start + (end - start) * MathEasing.elasticEaseOut(t);
    }

    public static int elasticEaseOutLerp(int start, int end, float t) {
        return (int)((float)start + (float)(end - start) * MathEasing.elasticEaseOut(t));
    }
}

