/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.gl.state;

import java.util.Arrays;
import net.caffeinemc.mods.sodium.client.gl.array.GlVertexArray;
import net.caffeinemc.mods.sodium.client.gl.buffer.GlBuffer;
import net.caffeinemc.mods.sodium.client.gl.buffer.GlBufferTarget;

public class GlStateTracker {
    private static final int UNASSIGNED_HANDLE = -1;
    private final int[] bufferState = new int[GlBufferTarget.COUNT];
    private int vertexArrayState;

    public void notifyVertexArrayDeleted(GlVertexArray vertexArray) {
        if (this.vertexArrayState == vertexArray.handle()) {
            this.vertexArrayState = -1;
        }
    }

    public void notifyBufferDeleted(GlBuffer buffer) {
        for (GlBufferTarget target : GlBufferTarget.VALUES) {
            if (this.bufferState[target.ordinal()] != buffer.handle()) continue;
            this.bufferState[target.ordinal()] = -1;
        }
    }

    public boolean makeBufferActive(GlBufferTarget target, GlBuffer buffer) {
        boolean changed;
        boolean bl = changed = this.bufferState[target.ordinal()] != buffer.handle();
        if (changed) {
            this.bufferState[target.ordinal()] = buffer.handle();
        }
        return changed;
    }

    public boolean makeVertexArrayActive(GlVertexArray array) {
        boolean changed;
        int handle = array == null ? 0 : array.handle();
        boolean bl = changed = this.vertexArrayState != handle;
        if (changed) {
            this.vertexArrayState = handle;
            Arrays.fill(this.bufferState, -1);
        }
        return changed;
    }

    public void clear() {
        Arrays.fill(this.bufferState, -1);
        this.vertexArrayState = -1;
    }
}

