/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting;

import it.unimi.dsi.fastutil.floats.FloatArrays;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class AlignableNormal
extends Vector3f {
    private static final AlignableNormal[] NORMALS = new AlignableNormal[ModelQuadFacing.DIRECTIONS];
    private static final int UNASSIGNED;
    private final int alignedDirection;

    private AlignableNormal(Vector3fc v, int alignedDirection) {
        super(v);
        this.alignedDirection = alignedDirection;
    }

    public static AlignableNormal fromAligned(int alignedDirection) {
        return NORMALS[alignedDirection];
    }

    public static AlignableNormal fromUnaligned(Vector3fc v) {
        return new AlignableNormal(v, UNASSIGNED);
    }

    public int getAlignedDirection() {
        return this.alignedDirection;
    }

    public boolean isAligned() {
        return this.alignedDirection != UNASSIGNED;
    }

    public int hashCode() {
        if (this.isAligned()) {
            return this.alignedDirection;
        }
        return super.hashCode() + ModelQuadFacing.DIRECTIONS;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AlignableNormal other = (AlignableNormal)((Object)obj);
        return this.alignedDirection == other.alignedDirection;
    }

    public static boolean queryRange(float[] sortedDistances, float start, float end) {
        int result = FloatArrays.binarySearch((float[])sortedDistances, (float)start);
        if (result < 0) {
            int insertionPoint = -result - 1;
            if (insertionPoint >= sortedDistances.length) {
                return false;
            }
            return sortedDistances[insertionPoint] <= end;
        }
        return true;
    }

    static {
        for (int i = 0; i < ModelQuadFacing.DIRECTIONS; ++i) {
            AlignableNormal.NORMALS[i] = new AlignableNormal(ModelQuadFacing.ALIGNED_NORMALS[i], i);
        }
        UNASSIGNED = ModelQuadFacing.UNASSIGNED.ordinal();
    }
}

