/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.mixin.features.render.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.api.vertex.format.common.ParticleVertex;
import net.caffeinemc.mods.sodium.client.render.vertex.VertexConsumerUtils;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SingleQuadParticle;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.lwjgl.system.MemoryStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SingleQuadParticle.class})
public abstract class SingleQuadParticleMixin
extends Particle {
    @Unique
    private final Vector3f sodium$scratchVertex = new Vector3f();

    @Shadow
    public abstract float getQuadSize(float var1);

    @Shadow
    protected abstract float getU0();

    @Shadow
    protected abstract float getU1();

    @Shadow
    protected abstract float getV0();

    @Shadow
    protected abstract float getV1();

    protected SingleQuadParticleMixin(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
    }

    @Inject(method={"renderRotatedQuad(Lcom/mojang/blaze3d/vertex/VertexConsumer;Lorg/joml/Quaternionf;FFFF)V"}, at={@At(value="HEAD")}, cancellable=true)
    protected void renderRotatedQuad(VertexConsumer vertexConsumer, Quaternionf quaternionf, float x, float y, float z, float tickDelta, CallbackInfo ci) {
        VertexBufferWriter writer = VertexConsumerUtils.convertOrLog(vertexConsumer);
        if (writer == null) {
            return;
        }
        ci.cancel();
        float size = this.getQuadSize(tickDelta);
        float minU = this.getU0();
        float maxU = this.getU1();
        float minV = this.getV0();
        float maxV = this.getV1();
        int light = this.getLightColor(tickDelta);
        int color = ColorABGR.pack(this.rCol, this.gCol, this.bCol, this.alpha);
        try (MemoryStack stack = MemoryStack.stackPush();){
            long buffer;
            long ptr = buffer = stack.nmalloc(112);
            this.sodium$writeVertex(ptr, quaternionf, x, y, z, 1.0f, -1.0f, size, maxU, maxV, color, light);
            this.sodium$writeVertex(ptr += 28L, quaternionf, x, y, z, 1.0f, 1.0f, size, maxU, minV, color, light);
            this.sodium$writeVertex(ptr += 28L, quaternionf, x, y, z, -1.0f, 1.0f, size, minU, minV, color, light);
            this.sodium$writeVertex(ptr += 28L, quaternionf, x, y, z, -1.0f, -1.0f, size, minU, maxV, color, light);
            ptr += 28L;
            writer.push(stack, buffer, 4, ParticleVertex.FORMAT);
        }
    }

    @Unique
    private void sodium$writeVertex(long ptr, Quaternionf quaternionf, float originX, float originY, float originZ, float posX, float posY, float size, float u, float v, int color, int light) {
        Vector3f vertex = this.sodium$scratchVertex;
        vertex.set(posX, posY, 0.0f);
        vertex.rotate((Quaternionfc)quaternionf);
        vertex.mul(size);
        vertex.add(originX, originY, originZ);
        ParticleVertex.put(ptr, vertex.x(), vertex.y(), vertex.z(), u, v, color, light);
    }
}

