/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.neoforge;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.caffeinemc.mods.sodium.client.services.PlatformMixinOverrides;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.moddiscovery.ModInfo;

public class ForgeMixinOverrides
implements PlatformMixinOverrides {
    protected static final String JSON_KEY_SODIUM_OPTIONS = "sodium:options";

    @Override
    public List<PlatformMixinOverrides.MixinOverride> applyModOverrides() {
        ArrayList<PlatformMixinOverrides.MixinOverride> list = new ArrayList<PlatformMixinOverrides.MixinOverride>();
        for (ModInfo meta : FMLLoader.getLoadingModList().getMods()) {
            meta.getConfigElement(new String[]{JSON_KEY_SODIUM_OPTIONS}).ifPresent(override -> {
                Map overrides;
                if (override instanceof Map && (overrides = (Map)override).keySet().stream().allMatch(key -> key instanceof String)) {
                    overrides.forEach((key, value) -> {
                        if (!(value instanceof Boolean) || !(key instanceof String)) {
                            System.out.printf("[Sodium] Mod '%s' attempted to override option '%s' with an invalid value, ignoring", meta.getModId(), key);
                            return;
                        }
                        list.add(new PlatformMixinOverrides.MixinOverride(meta.getModId(), (String)key, (Boolean)value));
                    });
                } else {
                    System.out.printf("[Sodium] '%s' contains invalid Sodium option overrides, ignoring", meta.getModId());
                }
            });
        }
        return list;
    }
}

