/*
 * Decompiled with CFR 0.152.
 */
package net.Pandarix.block.custom;

import com.mojang.serialization.MapCodec;
import net.Pandarix.block.entity.ArcheologyTableBlockEntity;
import net.Pandarix.block.entity.ModBlockEntities;
import net.Pandarix.util.ServerPlayerHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArchelogyTable
extends BaseEntityBlock {
    public static final MapCodec<ArchelogyTable> CODEC = ArchelogyTable.simpleCodec(ArchelogyTable::new);
    public static final BooleanProperty DUSTING = BooleanProperty.create((String)"dusting");

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public ArchelogyTable(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)DUSTING, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{DUSTING});
    }

    @NotNull
    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof ArcheologyTableBlockEntity) {
            ArcheologyTableBlockEntity archeologyTableBlockEntity = (ArcheologyTableBlockEntity)blockEntity;
            Containers.dropContents((Level)level, (BlockPos)pos, (Container)archeologyTableBlockEntity);
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, level, pos, newState, moved);
    }

    @NotNull
    public InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        if (!pLevel.isClientSide()) {
            BlockEntity entity = pLevel.getBlockEntity(pPos);
            if (entity instanceof ArcheologyTableBlockEntity) {
                ServerPlayerHelper.tryOpenScreen(pPlayer, (MenuProvider)((ArcheologyTableBlockEntity)entity));
            } else {
                throw new IllegalStateException("Container Provider Missing!");
            }
        }
        return InteractionResult.sidedSuccess((boolean)pLevel.isClientSide());
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ArcheologyTableBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return ArchelogyTable.createTickerHelper(pBlockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.ARCHEOLOGY_TABLE.get()), ArcheologyTableBlockEntity::tick);
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pLevel.isClientSide() && ((Boolean)pState.getValue((Property)DUSTING)).booleanValue()) {
            this.addDustParticles(pLevel, pPos, pRandom);
        }
        super.animateTick(pState, pLevel, pPos, pRandom);
    }

    public void addDustParticles(Level pLevel, BlockPos pos, RandomSource random) {
        if (random.nextBoolean()) {
            return;
        }
        int i = random.nextIntBetweenInclusive(1, 3);
        BlockParticleOption blockStateParticleEffect = new BlockParticleOption(ParticleTypes.BLOCK, Blocks.SAND.defaultBlockState());
        for (int j = 0; j < i; ++j) {
            pLevel.addParticle((ParticleOptions)blockStateParticleEffect, (double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5, 3.0 * random.nextDouble() * (double)(random.nextBoolean() ? 1 : -1), 0.0, 3.0 * random.nextDouble() * (double)(random.nextBoolean() ? 1 : -1));
        }
    }
}

