/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.capability.registrar.BlockEntityCapabilityRegistrar;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.evilcraft.RegistryEntries;

public class BlockEntityBloodStain
extends CyclopsBlockEntity {
    public static final int CAPACITY = 5000;
    @NBTPersist
    private Integer amount = 0;

    public BlockEntityBloodStain(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RegistryEntries.BLOCK_ENTITY_BLOOD_STAIN.get(), blockPos, blockState);
    }

    public int getAmount() {
        return this.amount;
    }

    public void addAmount(int amount) {
        this.amount = Math.min(5000, Math.max(0, this.amount + amount));
        if (this.amount == 0) {
            this.getLevel().removeBlock(this.getBlockPos(), false);
        }
        this.setChanged();
    }

    public static class FluidHandler
    implements IFluidHandler {
        private final BlockEntityBloodStain tile;

        public FluidHandler(BlockEntityBloodStain tile) {
            this.tile = tile;
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return new FluidStack(RegistryEntries.FLUID_BLOOD, this.tile.getAmount());
        }

        public int getTankCapacity(int tank) {
            return 5000;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return tank == 0 && stack.getFluid() == RegistryEntries.FLUID_BLOOD.get();
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.getFluid() == RegistryEntries.FLUID_BLOOD.get()) {
                return this.drain(resource.getAmount(), action);
            }
            return FluidStack.EMPTY;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            maxDrain = Math.min(this.tile.getAmount(), maxDrain);
            FluidStack drained = new FluidStack(RegistryEntries.FLUID_BLOOD, maxDrain);
            if (action.execute()) {
                this.tile.addAmount(-maxDrain);
            }
            return drained;
        }
    }

    public static class CapabilityRegistrar
    extends BlockEntityCapabilityRegistrar<BlockEntityBloodStain> {
        public CapabilityRegistrar(Supplier<BlockEntityType<? extends BlockEntityBloodStain>> blockEntityType) {
            super(blockEntityType);
        }

        public void populate() {
            this.add(Capabilities.FluidHandler.BLOCK, (blockEntity, direction) -> new FluidHandler((BlockEntityBloodStain)((Object)blockEntity)));
        }
    }
}

