/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity.tickaction;

import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.evilcraft.blockentity.tickaction.EmptyInTankTickAction;
import org.cyclops.evilcraft.core.blockentity.BlockEntityTankInventory;
import org.cyclops.evilcraft.core.blockentity.BlockEntityTickingTankInventory;

public class EmptyFluidContainerInTankTickAction<T extends BlockEntityTickingTankInventory<T>>
extends EmptyInTankTickAction<T> {
    @Override
    public void onTick(T tile, ItemStack itemStack, int slot, int tick) {
        FluidActionResult result;
        ItemStack containerStack = ((BlockEntityTankInventory)((Object)tile)).getInventory().getItem(slot).copy();
        IFluidHandler container = FluidUtil.getFluidHandler((ItemStack)containerStack).orElse(null);
        if (container != null && FluidHelpers.hasFluid((IFluidHandler)container) && (result = FluidUtil.getFluidHandler((ItemStack)containerStack).map(h -> !h.drain(MB_PER_TICK, IFluidHandler.FluidAction.SIMULATE).isEmpty()).orElse(false) != false ? FluidUtil.tryEmptyContainer((ItemStack)containerStack.split(1), (IFluidHandler)((BlockEntityTankInventory)((Object)tile)).getTank(), (int)MB_PER_TICK, null, (boolean)true) : FluidUtil.tryEmptyContainer((ItemStack)containerStack.split(1), (IFluidHandler)((BlockEntityTankInventory)((Object)tile)).getTank(), (int)1000, null, (boolean)true)).isSuccess()) {
            ItemStack resultStack = result.getResult();
            if (resultStack.getCount() == 0) {
                resultStack = containerStack;
                if (resultStack.getCount() == 0) {
                    resultStack = ItemStack.EMPTY;
                }
            } else if (containerStack.getCount() > 0) {
                ItemStackHelpers.spawnItemStack((Level)tile.getLevel(), (BlockPos)tile.getBlockPos(), (ItemStack)resultStack.copy());
                resultStack = containerStack;
            }
            ((BlockEntityTankInventory)((Object)tile)).getInventory().setItem(slot, resultStack);
        }
    }

    @Override
    public float getRequiredTicks(T tile, int slot, int tick) {
        return EmptyFluidContainerInTankTickAction.getRequiredTicks(tile, ((BlockEntityTankInventory)((Object)tile)).getInventory().getItem(slot));
    }

    public static int getRequiredTicks(BlockEntityTankInventory tile, ItemStack itemStack) {
        IFluidHandler container = FluidUtil.getFluidHandler((ItemStack)itemStack).orElse(null);
        int amount = 0;
        if (container != null && FluidHelpers.hasFluid((IFluidHandler)container)) {
            amount = FluidHelpers.getAmount((FluidStack)FluidHelpers.getFluid((IFluidHandler)container));
        }
        int capacity = Math.min(FluidHelpers.getCapacity((IFluidHandler)container), tile.getTank().getFluidAmount());
        return (capacity - amount) / MB_PER_TICK;
    }

    @Override
    public boolean canTick(T tile, ItemStack itemStack, int slot, int tick) {
        boolean emptyContainer = false;
        ItemStack containerStack = ((BlockEntityTankInventory)((Object)tile)).getInventory().getItem(slot);
        IFluidHandler container = FluidUtil.getFluidHandler((ItemStack)containerStack).orElse(null);
        if (container != null && FluidHelpers.hasFluid((IFluidHandler)container)) {
            FluidStack fluidStack = FluidHelpers.getFluid((IFluidHandler)container);
            if (FluidHelpers.getAmount((FluidStack)fluidStack) <= 0) {
                emptyContainer = true;
            }
        } else {
            emptyContainer = true;
        }
        return super.canTick(tile, itemStack, slot, tick) && !emptyContainer;
    }
}

