/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.degradation.effect;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.cyclops.cyclopscore.helper.LocationHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.api.degradation.IDegradable;
import org.cyclops.evilcraft.core.config.extendedconfig.DegradationEffectConfig;
import org.cyclops.evilcraft.core.degradation.StochasticDegradationEffect;

public class TerraformDegradation
extends StochasticDegradationEffect {
    private static Map<Block, Map<BlockState, Integer>> TERRAFORMATIONS = Maps.newHashMap();
    private static final double CHANCE = 0.1;
    private static Random random = new Random();

    private static void generateReplacements() {
        TerraformDegradation.putReplacement(null, Blocks.COBBLESTONE.defaultBlockState(), 30);
        TerraformDegradation.putReplacement(Blocks.STONE, Blocks.COBBLESTONE.defaultBlockState());
        TerraformDegradation.putReplacement(Blocks.COBBLESTONE, Blocks.DIRT.defaultBlockState(), 10);
        TerraformDegradation.putReplacement(Blocks.COBBLESTONE, Blocks.LAVA.defaultBlockState(), 30);
        TerraformDegradation.putReplacement(Blocks.COAL_BLOCK, Blocks.DIAMOND_BLOCK.defaultBlockState(), 10000);
        TerraformDegradation.putReplacement(Blocks.DIRT, Blocks.NETHERRACK.defaultBlockState(), 30);
        TerraformDegradation.putReplacement(Blocks.GRASS_BLOCK, Blocks.NETHERRACK.defaultBlockState(), 20);
        TerraformDegradation.putReplacement(Blocks.MYCELIUM, Blocks.NETHERRACK.defaultBlockState(), 5);
        TerraformDegradation.putReplacement(Blocks.DIRT, Blocks.SAND.defaultBlockState());
        TerraformDegradation.putReplacement(Blocks.GRASS_BLOCK, Blocks.SAND.defaultBlockState());
        TerraformDegradation.putReplacement(Blocks.MYCELIUM, Blocks.SAND.defaultBlockState());
        TerraformDegradation.putReplacement(Blocks.DIRT, Blocks.CLAY.defaultBlockState(), 20);
        TerraformDegradation.putReplacement(Blocks.GRASS_BLOCK, Blocks.SAND.defaultBlockState(), 20);
        TerraformDegradation.putReplacement(Blocks.MYCELIUM, Blocks.SAND.defaultBlockState(), 20);
        TerraformDegradation.putReplacement(Blocks.NETHERRACK, ((Block)RegistryEntries.BLOCK_INFESTED_NETHER_NETHERRACK.get()).defaultBlockState(), 50);
        TerraformDegradation.putReplacement(Blocks.SAND, null);
        TerraformDegradation.putReplacement(Blocks.WATER, null);
    }

    private static final void putReplacement(Block key, BlockState value) {
        TerraformDegradation.putReplacement(key, value, 0);
    }

    private static final void putReplacement(Block key, BlockState value, int chance) {
        Map<BlockState, Integer> mapValue = TERRAFORMATIONS.get(key);
        if (mapValue == null) {
            mapValue = new HashMap<BlockState, Integer>();
            TERRAFORMATIONS.put(key, mapValue);
        }
        mapValue.put(value, chance);
    }

    public TerraformDegradation(DegradationEffectConfig eConfig) {
        super(eConfig, 0.1);
    }

    @Override
    public void runClientSide(IDegradable degradable) {
    }

    protected BlockState getReplacement(Block block) {
        Object[] keys;
        BlockState holder;
        Integer chance;
        Map<BlockState, Integer> mapValue;
        if (TERRAFORMATIONS.isEmpty()) {
            TerraformDegradation.generateReplacements();
        }
        if ((mapValue = TERRAFORMATIONS.get(block)) == null) {
            mapValue = TERRAFORMATIONS.get(null);
        }
        if (mapValue != null && ((chance = mapValue.get(holder = (BlockState)(keys = mapValue.keySet().toArray())[random.nextInt(keys.length)])) == null || chance == 0 || random.nextInt(chance) == 0)) {
            return holder;
        }
        return null;
    }

    @Override
    public void runServerSide(IDegradable degradable) {
        BlockPos blockPos;
        Level world = degradable.getDegradationWorld();
        Block block = world.getBlockState(blockPos = LocationHelpers.getRandomPointInSphere((BlockPos)degradable.getLocation(), (int)degradable.getRadius())).getBlock();
        BlockState replace = this.getReplacement(block);
        if (replace != null && !degradable.getLocation().equals((Object)blockPos) && world.getBlockEntity(blockPos) == null) {
            if (replace.getBlock() == null) {
                world.removeBlock(blockPos, false);
            } else if (replace.getDestroySpeed((BlockGetter)world, blockPos) > 0.0f) {
                world.setBlock(blockPos, replace, 3);
            }
        }
    }
}

