/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.evilcraft.core.item.ItemBloodContainer;
import org.cyclops.evilcraft.entity.item.EntityBloodPearl;

public class ItemBloodPearlOfTeleportation
extends ItemBloodContainer {
    public ItemBloodPearlOfTeleportation(Item.Properties properties) {
        super(properties, 1000);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (this.canConsume(100, itemStack, player)) {
            this.consume(100, itemStack, player);
            world.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.NEUTRAL, 0.5f, 0.4f / (world.random.nextFloat() * 0.4f + 0.8f));
            if (!world.isClientSide()) {
                EntityBloodPearl pearl = new EntityBloodPearl(world, (LivingEntity)player);
                pearl.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.0f, 0.0f);
                pearl.setDeltaMovement(pearl.getDeltaMovement().multiply(3.0, 3.0, 3.0));
                world.addFreshEntity((Entity)pearl);
            }
            return MinecraftHelpers.successAction((Object)itemStack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)itemStack);
    }
}

