/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.client.renderer.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.EyesLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.salju.kobolds.client.model.KoboldModel;
import net.salju.kobolds.entity.AbstractKoboldEntity;

public class KoboldEyesLayer<S extends AbstractKoboldEntity, M extends KoboldModel<S>>
extends EyesLayer<S, M> {
    public KoboldEyesLayer(RenderLayerParent<S, M> parent) {
        super(parent);
    }

    public void render(PoseStack pose, MultiBufferSource buffer, int i, AbstractKoboldEntity kobold, float f1, float f2, float f3, float f4, float f5, float f6) {
        VertexConsumer eyes = buffer.getBuffer(this.renderType());
        if (kobold.isDiamond()) {
            eyes = buffer.getBuffer(this.renderDiamondType());
        } else if (kobold.getName().getString().equals("Popper")) {
            eyes = buffer.getBuffer(this.renderPopperType());
        }
        ((KoboldModel)this.getParentModel()).renderToBuffer(pose, eyes, 0xF00000, OverlayTexture.NO_OVERLAY);
    }

    public RenderType renderType() {
        return RenderType.eyes((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"kobolds", (String)"textures/entity/eyes/base.png"));
    }

    public RenderType renderDiamondType() {
        return RenderType.eyes((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"kobolds", (String)"textures/entity/eyes/diamond.png"));
    }

    public RenderType renderPopperType() {
        return RenderType.eyes((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"kobolds", (String)"textures/entity/eyes/popper.png"));
    }
}

