/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.tempad.client.tooltip;

import com.mojang.authlib.GameProfile;
import earth.terrarium.tempad.Tempad;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J0\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J(\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020#H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\u000e\u001a\n \n*\u0004\u0018\u00010\u000f0\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006$"}, d2={"Learth/terrarium/tempad/client/tooltip/PlayerPosTooltip;", "Lnet/minecraft/client/gui/screens/inventory/tooltip/ClientTooltipComponent;", "profile", "Lcom/mojang/authlib/GameProfile;", "<init>", "(Lcom/mojang/authlib/GameProfile;)V", "getProfile", "()Lcom/mojang/authlib/GameProfile;", "text", "Lnet/minecraft/network/chat/MutableComponent;", "kotlin.jvm.PlatformType", "getText", "()Lnet/minecraft/network/chat/MutableComponent;", "Lnet/minecraft/network/chat/MutableComponent;", "playerTexture", "Lnet/minecraft/resources/ResourceLocation;", "getPlayerTexture", "()Lnet/minecraft/resources/ResourceLocation;", "getHeight", "", "getWidth", "font", "Lnet/minecraft/client/gui/Font;", "renderText", "", "mouseX", "mouseY", "matrix", "Lorg/joml/Matrix4f;", "bufferSource", "Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;", "renderImage", "x", "y", "guiGraphics", "Lnet/minecraft/client/gui/GuiGraphics;", "tempad-1.21.1"})
public final class PlayerPosTooltip
implements ClientTooltipComponent {
    @NotNull
    private final GameProfile profile;
    private final MutableComponent text;

    public PlayerPosTooltip(@NotNull GameProfile profile) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        this.profile = profile;
        this.text = Component.literal((String)this.profile.getName());
    }

    @NotNull
    public final GameProfile getProfile() {
        return this.profile;
    }

    public final MutableComponent getText() {
        return this.text;
    }

    public final ResourceLocation getPlayerTexture() {
        return Minecraft.getInstance().getSkinManager().getInsecureSkin(this.profile).texture();
    }

    public int getHeight() {
        return 10;
    }

    public int getWidth(@NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        return font.width((FormattedText)this.text) + 13;
    }

    public void renderText(@NotNull Font font, int mouseX, int mouseY, @NotNull Matrix4f matrix, @NotNull MultiBufferSource.BufferSource bufferSource) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        Intrinsics.checkNotNullParameter((Object)bufferSource, (String)"bufferSource");
        super.renderText(font, mouseX, mouseY, matrix, bufferSource);
        font.drawInBatch((Component)this.text, (float)mouseX + (float)13, (float)mouseY + 1.0f, Tempad.Companion.getORANGE().getValue(), true, matrix, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    public void renderImage(@NotNull Font font, int x, int y, @NotNull GuiGraphics guiGraphics) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        super.renderImage(font, x, y, guiGraphics);
        PlayerFaceRenderer.draw((GuiGraphics)guiGraphics, (ResourceLocation)this.getPlayerTexture(), (int)x, (int)y, (int)9);
    }
}

