/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.tempad.common.block;

import com.mojang.serialization.MapCodec;
import earth.terrarium.tempad.common.block.RudimentaryTempadBE;
import earth.terrarium.tempad.common.registries.ModBlocks;
import earth.terrarium.tempad.common.registries.ModComponentsKt;
import earth.terrarium.tempad.common.registries.ModItems;
import earth.terrarium.tempad.common.utils.ItemStackBuilderKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 62\u00020\u0001:\u00016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0014J@\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J0\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001aH\u0014J8\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$H\u0014J(\u0010%\u001a\u00020\u001f2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020&2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010'\u001a\u00020(H\u0014J\u0010\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010*H\u0014J\u0018\u0010+\u001a\u00020,2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J \u0010-\u001a\u00020\u001f2\u0016\u0010.\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010!\u0012\u0006\u0012\u0004\u0018\u00010\u00050/H\u0014J\u0010\u00100\u001a\u0002012\u0006\u0010\u000b\u001a\u00020\u0005H\u0014J(\u00102\u001a\u0002032\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u0002042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u000205H\u0014\u00a8\u00067"}, d2={"Learth/terrarium/tempad/common/block/RudimentaryTempadBlock;", "Lnet/minecraft/world/level/block/BaseEntityBlock;", "<init>", "()V", "getStateForPlacement", "Lnet/minecraft/world/level/block/state/BlockState;", "context", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "getDrops", "", "Lnet/minecraft/world/item/ItemStack;", "state", "params", "Lnet/minecraft/world/level/storage/loot/LootParams$Builder;", "useItemOn", "Lnet/minecraft/world/ItemInteractionResult;", "stack", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "result", "Lnet/minecraft/world/phys/BlockHitResult;", "useWithoutItem", "Lnet/minecraft/world/InteractionResult;", "hitResult", "neighborChanged", "", "block", "Lnet/minecraft/world/level/block/Block;", "fromPos", "isMoving", "", "tick", "Lnet/minecraft/server/level/ServerLevel;", "random", "Lnet/minecraft/util/RandomSource;", "codec", "Lcom/mojang/serialization/MapCodec;", "newBlockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "createBlockStateDefinition", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "getRenderShape", "Lnet/minecraft/world/level/block/RenderShape;", "getShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "Lnet/minecraft/world/level/BlockGetter;", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "Companion", "tempad-1.21.1"})
@SourceDebugExtension(value={"SMAP\nRudimentaryTempadBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RudimentaryTempadBlock.kt\nearth/terrarium/tempad/common/block/RudimentaryTempadBlock\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,191:1\n1863#2,2:192\n*S KotlinDebug\n*F\n+ 1 RudimentaryTempadBlock.kt\nearth/terrarium/tempad/common/block/RudimentaryTempadBlock\n*L\n128#1:192,2\n*E\n"})
public final class RudimentaryTempadBlock
extends BaseEntityBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final MapCodec<? extends BaseEntityBlock> codec;
    private static final BooleanProperty hasCardProperty;
    private static final VoxelShape base;
    private static final VoxelShape west;
    private static final VoxelShape east;
    private static final VoxelShape south;
    private static final VoxelShape north;

    public RudimentaryTempadBlock() {
        super(BlockBehaviour.Properties.of().strength(3.0f, 6.0f));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.TRIGGERED, (Comparable)Boolean.valueOf(false))).setValue((Property)hasCardProperty, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ItemStack itemStack = context.getItemInHand();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInHand(...)");
        boolean hasCard = ModComponentsKt.getPortalTarget((MutableDataComponentHolder)itemStack) != null;
        Object object = ((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection())).setValue((Property)hasCardProperty, (Comparable)Boolean.valueOf(hasCard));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
        return (BlockState)object;
    }

    @NotNull
    protected List<ItemStack> getDrops(@NotNull BlockState state, @NotNull LootParams.Builder params) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Object[] objectArray = new ItemStack[]{ItemStackBuilderKt.stack$default(ModItems.INSTANCE.getTimedoorProjector(), 0, arg_0 -> RudimentaryTempadBlock.getDrops$lambda$1(params, arg_0), 1, null)};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult result) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (Intrinsics.areEqual((Object)stack.getItem(), (Object)ModItems.INSTANCE.getLocationCard()) && ModComponentsKt.getPortalTarget((MutableDataComponentHolder)stack) != null) {
            if (level.isClientSide) {
                return ItemInteractionResult.SUCCESS;
            }
            BlockEntity blockEntity = level.getBlockEntity(pos);
            RudimentaryTempadBE rudimentaryTempadBE = blockEntity instanceof RudimentaryTempadBE ? (RudimentaryTempadBE)blockEntity : null;
            if (rudimentaryTempadBE == null) {
                return ItemInteractionResult.FAIL;
            }
            RudimentaryTempadBE blockEntity2 = rudimentaryTempadBE;
            if (blockEntity2.getPortalTarget() != null) {
                player.getInventory().placeItemBackInInventory(ItemStackBuilderKt.stack$default(ModItems.INSTANCE.getLocationCard(), 0, arg_0 -> RudimentaryTempadBlock.useItemOn$lambda$2(blockEntity2, arg_0), 1, null));
            }
            blockEntity2.setPortalTarget(ModComponentsKt.getPortalTarget((MutableDataComponentHolder)stack));
            level.setBlock(pos, (BlockState)state.setValue((Property)hasCardProperty, (Comparable)Boolean.valueOf(true)), 2);
            stack.shrink(1);
            return ItemInteractionResult.SUCCESS;
        }
        ItemInteractionResult itemInteractionResult = super.useItemOn(stack, state, level, pos, player, hand, result);
        Intrinsics.checkNotNullExpressionValue((Object)itemInteractionResult, (String)"useItemOn(...)");
        return itemInteractionResult;
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        RudimentaryTempadBE rudimentaryTempadBE = blockEntity instanceof RudimentaryTempadBE ? (RudimentaryTempadBE)blockEntity : null;
        if (rudimentaryTempadBE == null) {
            return InteractionResult.FAIL;
        }
        RudimentaryTempadBE blockEntity2 = rudimentaryTempadBE;
        if (player.isShiftKeyDown()) {
            List list = BaseEntityBlock.getDrops((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, (BlockEntity)((ServerLevel)level).getBlockEntity(pos));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDrops(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ItemStack it = (ItemStack)element$iv;
                boolean bl = false;
                if (player.getMainHandItem().isEmpty()) {
                    player.setItemInHand(InteractionHand.MAIN_HAND, it);
                    continue;
                }
                player.getInventory().placeItemBackInInventory(it);
            }
            ((ServerLevel)level).setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            return InteractionResult.SUCCESS;
        }
        if (blockEntity2.getPortalTarget() != null) {
            player.getInventory().placeItemBackInInventory(ItemStackBuilderKt.stack$default(ModItems.INSTANCE.getLocationCard(), 0, arg_0 -> RudimentaryTempadBlock.useWithoutItem$lambda$4(blockEntity2, arg_0), 1, null));
            blockEntity2.setPortalTarget(null);
            level.setBlock(pos, (BlockState)state.setValue((Property)hasCardProperty, (Comparable)Boolean.valueOf(false)), 2);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void neighborChanged(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos fromPos, boolean isMoving) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)fromPos, (String)"fromPos");
        boolean neighborPowered = level.hasNeighborSignal(pos) || level.hasNeighborSignal(pos.above());
        Boolean currentlyPowered = (Boolean)state.getValue((Property)BlockStateProperties.TRIGGERED);
        if (neighborPowered && !currentlyPowered.booleanValue()) {
            level.scheduleTick(pos, (Block)this, 4);
            level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.TRIGGERED, (Comparable)Boolean.valueOf(true)), 2);
        } else if (!neighborPowered && currentlyPowered.booleanValue()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.TRIGGERED, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    protected void tick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        super.tick(state, level, pos, random);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        RudimentaryTempadBE rudimentaryTempadBE = blockEntity instanceof RudimentaryTempadBE ? (RudimentaryTempadBE)blockEntity : null;
        if (rudimentaryTempadBE == null) {
            return;
        }
        RudimentaryTempadBE blockEntity2 = rudimentaryTempadBE;
        blockEntity2.openTimedoor();
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return codec;
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new RudimentaryTempadBE(pos, state);
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{BlockStateProperties.HORIZONTAL_FACING, BlockStateProperties.TRIGGERED, hasCardProperty};
        builder.add(propertyArray);
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return RenderShape.MODEL;
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        VoxelShape voxelShape;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Direction direction = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1: {
                VoxelShape voxelShape2 = north;
                voxelShape = voxelShape2;
                Intrinsics.checkNotNullExpressionValue((Object)voxelShape2, (String)"north");
                break;
            }
            case 2: {
                VoxelShape voxelShape3 = south;
                voxelShape = voxelShape3;
                Intrinsics.checkNotNullExpressionValue((Object)voxelShape3, (String)"south");
                break;
            }
            case 3: {
                VoxelShape voxelShape4 = east;
                voxelShape = voxelShape4;
                Intrinsics.checkNotNullExpressionValue((Object)voxelShape4, (String)"east");
                break;
            }
            case 4: {
                VoxelShape voxelShape5 = west;
                voxelShape = voxelShape5;
                Intrinsics.checkNotNullExpressionValue((Object)voxelShape5, (String)"west");
                break;
            }
            default: {
                VoxelShape voxelShape6 = base;
                voxelShape = voxelShape6;
                Intrinsics.checkNotNullExpressionValue((Object)voxelShape6, (String)"base");
            }
        }
        return voxelShape;
    }

    private static final Unit getDrops$lambda$1(LootParams.Builder $params, ItemStack $this$stack) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$this$stack, (String)"$this$stack");
            Object object = $params.getParameter(LootContextParams.BLOCK_ENTITY);
            RudimentaryTempadBE rudimentaryTempadBE = object instanceof RudimentaryTempadBE ? (RudimentaryTempadBE)((Object)object) : null;
            if (rudimentaryTempadBE == null) break block0;
            RudimentaryTempadBE it = rudimentaryTempadBE;
            boolean bl = false;
            ModComponentsKt.setChrononContent((MutableDataComponentHolder)$this$stack, it.getChrononContent());
            ModComponentsKt.setPortalTarget((MutableDataComponentHolder)$this$stack, it.getPortalTarget());
        }
        return Unit.INSTANCE;
    }

    private static final Unit useItemOn$lambda$2(RudimentaryTempadBE $blockEntity, ItemStack $this$stack) {
        Intrinsics.checkNotNullParameter((Object)$this$stack, (String)"$this$stack");
        ModComponentsKt.setPortalTarget((MutableDataComponentHolder)$this$stack, $blockEntity.getPortalTarget());
        return Unit.INSTANCE;
    }

    private static final Unit useWithoutItem$lambda$4(RudimentaryTempadBE $blockEntity, ItemStack $this$stack) {
        Intrinsics.checkNotNullParameter((Object)$this$stack, (String)"$this$stack");
        ModComponentsKt.setPortalTarget((MutableDataComponentHolder)$this$stack, $blockEntity.getPortalTarget());
        return Unit.INSTANCE;
    }

    private static final RudimentaryTempadBlock codec$lambda$5(BlockBehaviour.Properties it) {
        return ModBlocks.INSTANCE.getTimedoorProjector();
    }

    static {
        MapCodec mapCodec = BaseEntityBlock.simpleCodec(RudimentaryTempadBlock::codec$lambda$5);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"simpleCodec(...)");
        codec = mapCodec;
        hasCardProperty = BooleanProperty.create((String)"has_card");
        base = BaseEntityBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
        west = Shapes.or((VoxelShape)base, (VoxelShape)BaseEntityBlock.box((double)0.0, (double)2.0, (double)0.0, (double)8.0, (double)4.0, (double)8.0));
        east = Shapes.or((VoxelShape)base, (VoxelShape)BaseEntityBlock.box((double)8.0, (double)2.0, (double)8.0, (double)16.0, (double)4.0, (double)16.0));
        south = Shapes.or((VoxelShape)base, (VoxelShape)BaseEntityBlock.box((double)0.0, (double)2.0, (double)8.0, (double)8.0, (double)4.0, (double)16.0));
        north = Shapes.or((VoxelShape)base, (VoxelShape)BaseEntityBlock.box((double)8.0, (double)2.0, (double)0.0, (double)16.0, (double)4.0, (double)8.0));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000f\u001a\n \u000b*\u0004\u0018\u00010\u00100\u0010\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0014\u001a\n \u000b*\u0004\u0018\u00010\u00100\u0010\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0015\u0010\u0012R\u001b\u0010\u0016\u001a\n \u000b*\u0004\u0018\u00010\u00100\u0010\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0017\u0010\u0012R\u001b\u0010\u0018\u001a\n \u000b*\u0004\u0018\u00010\u00100\u0010\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0019\u0010\u0012R\u001b\u0010\u001a\u001a\n \u000b*\u0004\u0018\u00010\u00100\u0010\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u001b\u0010\u0012\u00a8\u0006\u001c"}, d2={"Learth/terrarium/tempad/common/block/RudimentaryTempadBlock$Companion;", "", "<init>", "()V", "codec", "Lcom/mojang/serialization/MapCodec;", "Lnet/minecraft/world/level/block/BaseEntityBlock;", "getCodec", "()Lcom/mojang/serialization/MapCodec;", "hasCardProperty", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "kotlin.jvm.PlatformType", "getHasCardProperty", "()Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "base", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getBase", "()Lnet/minecraft/world/phys/shapes/VoxelShape;", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "west", "getWest", "east", "getEast", "south", "getSouth", "north", "getNorth", "tempad-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MapCodec<? extends BaseEntityBlock> getCodec() {
            return codec;
        }

        public final BooleanProperty getHasCardProperty() {
            return hasCardProperty;
        }

        public final VoxelShape getBase() {
            return base;
        }

        public final VoxelShape getWest() {
            return west;
        }

        public final VoxelShape getEast() {
            return east;
        }

        public final VoxelShape getSouth() {
            return south;
        }

        public final VoxelShape getNorth() {
            return north;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.NORTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

