/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.tempad.common.items;

import earth.terrarium.tempad.api.context.ContextRegistry;
import earth.terrarium.tempad.api.context.SyncableContext;
import earth.terrarium.tempad.api.tva_device.ChrononHandler;
import earth.terrarium.tempad.api.tva_device.ChrononHandlerKt;
import earth.terrarium.tempad.client.tooltip.ChrononToolipKt;
import earth.terrarium.tempad.common.registries.ModTags;
import earth.terrarium.tempad.common.utils.ExtensionsKt;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bJ \u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\nH\u0016J\u0018\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0016\u00a8\u0006\u0018"}, d2={"Learth/terrarium/tempad/common/items/ChrononItem;", "Lnet/minecraft/world/item/Item;", "<init>", "()V", "getTooltipImage", "Ljava/util/Optional;", "Lnet/minecraft/world/inventory/tooltip/TooltipComponent;", "stack", "Lnet/minecraft/world/item/ItemStack;", "cannotDistribute", "", "entity", "Lnet/minecraft/world/entity/Entity;", "distribute", "", "player", "Lnet/minecraft/world/entity/player/Player;", "shouldCauseReequipAnimation", "oldStack", "newStack", "slotChanged", "isChargable", "source", "target", "tempad-1.21.1"})
@SourceDebugExtension(value={"SMAP\nChrononItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChrononItem.kt\nearth/terrarium/tempad/common/items/ChrononItem\n+ 2 Extensions.kt\nearth/terrarium/tempad/common/utils/ExtensionsKt\n*L\n1#1,40:1\n212#2:41\n*S KotlinDebug\n*F\n+ 1 ChrononItem.kt\nearth/terrarium/tempad/common/items/ChrononItem\n*L\n29#1:41\n*E\n"})
public abstract class ChrononItem
extends Item {
    public ChrononItem() {
        super(new Item.Properties().stacksTo(1));
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        ChrononHandler chrononHandler = ChrononHandlerKt.getChronons(stack);
        Optional<TooltipComponent> optional = Optional.ofNullable(chrononHandler != null ? ChrononToolipKt.getTooltip(chrononHandler) : null);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    public final boolean cannotDistribute(@NotNull Entity entity, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return !(entity instanceof Player) || ContextRegistry.INSTANCE.locate((Player)entity, (Function1<? super ItemStack, Boolean>)((Function1)arg_0 -> ChrononItem.cannotDistribute$lambda$0(this, stack, arg_0))) == null;
    }

    /*
     * WARNING - void declaration
     */
    public final void distribute(@NotNull Player player, @NotNull ItemStack stack) {
        block1: {
            void p1$iv;
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            SyncableContext<?> syncableContext = ContextRegistry.INSTANCE.locate(player, (Function1<? super ItemStack, Boolean>)((Function1)arg_0 -> ChrononItem.distribute$lambda$1(this, stack, arg_0)));
            if (syncableContext == null) break block1;
            SyncableContext<?> it = syncableContext;
            boolean bl = false;
            ChrononHandler chrononHandler = ChrononHandlerKt.getChronons(stack);
            ChrononHandler p2$iv = ChrononHandlerKt.getChronons(it.getStack());
            boolean $i$f$safeLet = false;
            if (p1$iv != null && p2$iv != null) {
                void to;
                ChrononHandler chrononHandler2 = p2$iv;
                void from = p1$iv;
                boolean bl2 = false;
                ChrononHandlerKt.move((ChrononHandler)from, (ChrononHandler)to, Integer.MAX_VALUE);
            }
        }
    }

    public boolean shouldCauseReequipAnimation(@NotNull ItemStack oldStack, @NotNull ItemStack newStack, boolean slotChanged) {
        Intrinsics.checkNotNullParameter((Object)oldStack, (String)"oldStack");
        Intrinsics.checkNotNullParameter((Object)newStack, (String)"newStack");
        return false;
    }

    public boolean isChargable(@NotNull ItemStack source, @NotNull ItemStack target) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        ChrononHandler chrononHandler = ChrononHandlerKt.getChronons(target);
        return (chrononHandler != null ? ChrononHandlerKt.getHasRoom(chrononHandler) : false) && target != source && !ExtensionsKt.contains(ModTags.INSTANCE.getChargeBlacklist(), target);
    }

    private static final boolean cannotDistribute$lambda$0(ChrononItem this$0, ItemStack $stack, ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isChargable($stack, it);
    }

    private static final boolean distribute$lambda$1(ChrononItem this$0, ItemStack $stack, ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isChargable($stack, it);
    }
}

