/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client;

import com.mojang.blaze3d.platform.InputConstants;
import ht.treechop.client.Client;
import ht.treechop.client.gui.screen.ClientSettingsScreen;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;

public class KeyBindings {
    public static final String CATEGORY = "HT's TreeChop";
    public static final List<ActionableKeyBinding> allKeyBindings = new LinkedList<ActionableKeyBinding>();

    public static void registerKeyMappings(Consumer<KeyMapping> register) {
        KeyBindings.registerKeyBinding("toggle_chopping", InputConstants.UNKNOWN, Client::toggleChopping, register);
        KeyBindings.registerKeyBinding("cycle_sneak_behavior", InputConstants.UNKNOWN, Client::cycleSneakBehavior, register);
        KeyBindings.registerKeyBinding("open_settings_overlay", KeyBindings.getKey(78), Client::toggleSettingsOverlay, register);
    }

    private static ActionableKeyBinding registerKeyBinding(String name, InputConstants.Key defaultKey, Runnable callback, Consumer<KeyMapping> register) {
        ActionableKeyBinding keyBinding = new ActionableKeyBinding(String.format("%s.key.%s", "treechop", name), defaultKey, callback);
        register.accept(keyBinding);
        allKeyBindings.add(keyBinding);
        return keyBinding;
    }

    static InputConstants.Key getKey(int key) {
        return InputConstants.getKey((int)key, (int)0);
    }

    public static class ActionableKeyBinding
    extends KeyMapping {
        private final Runnable callback = () -> {
            Screen screen = Minecraft.getInstance().screen;
            if (screen == null || screen instanceof ClientSettingsScreen) {
                callback.run();
            }
        };

        public ActionableKeyBinding(String resourceName, InputConstants.Key inputByCode, Runnable callback) {
            super(resourceName, InputConstants.Type.KEYSYM, inputByCode.getValue(), KeyBindings.CATEGORY);
        }

        public void onPress() {
            this.callback.run();
        }
    }
}

