/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client.gui.element;

import ht.treechop.client.gui.element.NestedGui;
import ht.treechop.client.gui.util.GUIUtil;
import ht.treechop.client.gui.widget.StickyWidget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

public class ExclusiveButtonsGui
extends NestedGui {
    private final List<AbstractWidget> widgets;
    private final Supplier<Component> tooltipSupplier;

    protected ExclusiveButtonsGui(Collection<AbstractWidget> widgets, Supplier<Component> tooltipSupplier) {
        super(0, 0, 0, 0, (Component)Component.empty());
        this.widgets = new ArrayList<AbstractWidget>(widgets);
        this.tooltipSupplier = tooltipSupplier;
    }

    @Override
    public void expand(int width) {
        if (this.getMinimumWidth() < width) {
            int targetWidth = width / this.widgets.size();
            List smallerWidgets = this.widgets.stream().filter(widget -> widget.getWidth() <= targetWidth).collect(Collectors.toList());
            List biggerWidgets = this.widgets.stream().filter(widget -> widget.getWidth() > targetWidth).collect(Collectors.toList());
            int totalWidthForSmallers = width - biggerWidgets.stream().map(AbstractWidget::getWidth).reduce(Integer::sum).orElse(0);
            int i = 0;
            for (AbstractWidget widget2 : smallerWidgets) {
                double lower = (double)i / (double)smallerWidgets.size();
                double upper = (double)(i + 1) / (double)smallerWidgets.size();
                int widgetWidth = (int)((double)totalWidthForSmallers * (upper - lower));
                widget2.setWidth(widgetWidth);
                ++i;
            }
        }
    }

    public List<? extends GuiEventListener> children() {
        return this.widgets;
    }

    public void renderWidget(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        int x = this.getBox().getLeft();
        int y = this.getBox().getTop();
        int maxX = x;
        int maxY = y;
        for (AbstractWidget widget : this.widgets) {
            widget.setX(maxX);
            widget.setY(y);
            widget.render(gui, mouseX, mouseY, partialTicks);
            maxX = Math.max(maxX, maxX + widget.getWidth());
            maxY = Math.max(maxY, y + widget.getHeight());
        }
        boolean bl = this.isHovered = mouseX >= x && mouseY >= y && mouseX < maxX && mouseY < maxY;
        if (this.isHoveredOrFocused()) {
            GUIUtil.showTooltip(mouseX, mouseY, this.tooltipSupplier.get());
        }
    }

    @Override
    public int getMinimumWidth() {
        return this.widgets.stream().map(AbstractWidget::getWidth).reduce(Integer::sum).orElse(0);
    }

    @Override
    public int getMinimumHeight() {
        return this.widgets.stream().map(AbstractWidget::getHeight).reduce(Integer::max).orElse(0);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public static class Builder {
        private final List<Option> options = new LinkedList<Option>();

        public Builder add(Component name, Runnable onPress, Supplier<StickyWidget.State> stateSupplier) {
            this.options.add(new Option(name, onPress, stateSupplier));
            return this;
        }

        public ExclusiveButtonsGui build(Supplier<Component> tooltipSupplier) {
            List<AbstractWidget> widgets = this.options.stream().map(option -> new StickyWidget(0, 0, 0, 0, option.name, option.onPress, option.stateSupplier)).collect(Collectors.toList());
            return new ExclusiveButtonsGui(widgets, tooltipSupplier);
        }

        private static class Option {
            private final Component name;
            private final Runnable onPress;
            private final Supplier<StickyWidget.State> stateSupplier;

            public Option(Component name, Runnable onPress, Supplier<StickyWidget.State> stateSupplier) {
                this.name = name;
                this.onPress = onPress;
                this.stateSupplier = stateSupplier;
            }
        }
    }
}

