/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.client.gui.widget;

import ht.treechop.client.gui.util.Sprite;
import java.util.EnumMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.tuple.Pair;

public class ToggleWidget
extends AbstractWidget {
    private final Supplier<State> stateSupplier;
    private final Runnable onPress;

    public ToggleWidget(int x, int y, Runnable onPress, Supplier<State> stateSupplier) {
        super(x, y, Sprite.TOGGLE_BUTTON_OFF.width, Sprite.TOGGLE_BUTTON_OFF.height, (Component)Component.empty());
        this.onPress = onPress;
        this.stateSupplier = stateSupplier;
    }

    public void onClick(double mouseX, double mouseY) {
        this.onPress.run();
    }

    public void renderWidget(GuiGraphics gui, int mouseX, int mouseY, float partialTicks) {
        this.active = !this.stateSupplier.get().isLocked;
        Sprite.setRenderState(this.alpha);
        EnumMap<State, Sprite> spriteForState = new EnumMap<State, Sprite>(Stream.of(Pair.of((Object)((Object)State.OFF), (Object)((Object)Sprite.TOGGLE_BUTTON_OFF)), Pair.of((Object)((Object)State.ON), (Object)((Object)Sprite.TOGGLE_BUTTON_ON)), Pair.of((Object)((Object)State.LOCKED_OFF), (Object)((Object)Sprite.LOCKED_TOGGLE_BUTTON_OFF)), Pair.of((Object)((Object)State.LOCKED_ON), (Object)((Object)Sprite.LOCKED_TOGGLE_BUTTON_ON))).collect(Collectors.toMap(Pair::getLeft, Pair::getRight)));
        EnumMap<State, Sprite> spriteForHoveredState = new EnumMap<State, Sprite>(Stream.of(Pair.of((Object)((Object)State.OFF), (Object)((Object)Sprite.HIGHLIGHTED_TOGGLE_BUTTON_OFF)), Pair.of((Object)((Object)State.ON), (Object)((Object)Sprite.HIGHLIGHTED_TOGGLE_BUTTON_ON)), Pair.of((Object)((Object)State.LOCKED_OFF), (Object)((Object)Sprite.LOCKED_TOGGLE_BUTTON_OFF)), Pair.of((Object)((Object)State.LOCKED_ON), (Object)((Object)Sprite.LOCKED_TOGGLE_BUTTON_ON))).collect(Collectors.toMap(Pair::getLeft, Pair::getRight)));
        State state = this.stateSupplier.get();
        Sprite sprite = this.isHoveredOrFocused() ? spriteForHoveredState.get((Object)state) : spriteForState.get((Object)state);
        sprite.blit(gui, this.getX(), this.getY());
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public static enum State {
        ON(true, false),
        OFF(false, false),
        LOCKED_ON(true, true),
        LOCKED_OFF(false, true);

        public final boolean isOn;
        private final boolean isLocked;

        private State(boolean isOn, boolean isLocked) {
            this.isOn = isOn;
            this.isLocked = isLocked;
        }

        public static State of(boolean enabled, boolean canBeEnabled) {
            if (canBeEnabled) {
                return enabled ? ON : OFF;
            }
            return enabled ? LOCKED_ON : LOCKED_OFF;
        }
    }
}

