/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.common.chop;

import ht.treechop.TreeChop;
import ht.treechop.api.ILeaveslikeBlock;
import ht.treechop.api.TreeData;
import ht.treechop.common.chop.Chop;
import ht.treechop.common.chop.ChopResult;
import ht.treechop.common.chop.FellDataImpl;
import ht.treechop.common.config.ConfigHandler;
import ht.treechop.common.config.FellCreditStrategy;
import ht.treechop.common.config.FellLeavesStrategy;
import ht.treechop.common.util.ClassUtil;
import ht.treechop.common.util.LevelUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class FellTreeResult
implements ChopResult {
    private final Level level;
    private final FellDataImpl fellData;
    private final Collection<Chop> chops;

    public FellTreeResult(Level level, TreeData tree, boolean breakLeaves, Collection<Chop> chops) {
        this.level = level;
        this.fellData = new FellDataImpl(tree, breakLeaves);
        this.chops = chops;
    }

    @Override
    public void apply(BlockPos targetPos, ServerPlayer player, ItemStack tool) {
        ServerLevel serverLevel;
        GameType gameType = player.gameMode.getGameModeForPlayer();
        Level level = this.level;
        if (level instanceof ServerLevel && !(serverLevel = (ServerLevel)level).getBlockState(targetPos).isAir() && !player.blockActionRestricted((Level)serverLevel, targetPos, gameType)) {
            boolean fell = TreeChop.platform.startFellTreeEvent(player, this.level, targetPos, this.fellData);
            this.chops.forEach(chop -> chop.apply(this.level, (Player)player, tool, fell));
            if (fell) {
                Consumer<BlockPos> blockBreaker = FellTreeResult.makeBlockBreaker(player, serverLevel);
                FellTreeResult.breakLogs(player, serverLevel, this.fellData.getTree(), gameType, blockBreaker, targetPos);
                if (this.fellData.getBreakLeaves()) {
                    FellTreeResult.breakLeaves(player, serverLevel, this.fellData.getTree(), gameType, blockBreaker);
                }
                TreeChop.platform.finishFellTreeEvent(player, this.level, targetPos, this.fellData);
            }
        }
    }

    @NotNull
    private static Consumer<BlockPos> makeBlockBreaker(ServerPlayer player, ServerLevel level) {
        if (player.isCreative()) {
            BlockState air = Blocks.AIR.defaultBlockState();
            return pos -> level.setBlockAndUpdate(pos, air);
        }
        ServerPlayer creditPlayer = ConfigHandler.COMMON.fellCreditStrategy.get() == FellCreditStrategy.NONE ? null : player;
        ItemStack creditTool = ConfigHandler.COMMON.fellCreditStrategy.get() == FellCreditStrategy.PLAYER_AND_TOOL ? player.getMainHandItem() : ItemStack.EMPTY;
        return pos -> LevelUtil.harvestBlock((Entity)creditPlayer, (Level)level, pos, creditTool, false);
    }

    private static void breakLogs(ServerPlayer player, ServerLevel level, TreeData tree, GameType gameType, Consumer<BlockPos> blockBreaker, BlockPos targetPos) {
        long maxNumEffects = 4L;
        AtomicInteger i = new AtomicInteger(0);
        PriorityQueue<Pair> effects = new PriorityQueue<Pair>(Comparator.comparing(pair -> ((BlockPos)pair.getLeft()).getY()));
        tree.streamLogs().filter(pos -> !pos.equals((Object)targetPos) && !player.blockActionRestricted((Level)level, targetPos, gameType)).forEach(pos -> {
            FellTreeResult.collectSomeBlocks(effects, pos, level.getBlockState(pos), i, 3);
            blockBreaker.accept((BlockPos)pos);
        });
        effects.stream().limit(4L).forEach(posState -> FellTreeResult.playBlockBreakEffects((Level)level, (BlockPos)posState.getLeft(), (BlockState)posState.getRight()));
    }

    private static void breakLeaves(ServerPlayer player, ServerLevel level, TreeData tree, GameType gameType, Consumer<BlockPos> blockBreaker) {
        long maxNumEffects = 5L;
        AtomicInteger i = new AtomicInteger(0);
        PriorityQueue<Pair> effects = new PriorityQueue<Pair>(Comparator.comparing(pair -> ((BlockPos)pair.getLeft()).getY()));
        boolean tryToDecay = ConfigHandler.COMMON.fellLeavesStrategy.get() == FellLeavesStrategy.DECAY;
        Consumer<BlockPos> leavesBreaker = pos -> {
            if (!player.blockActionRestricted((Level)level, pos, gameType)) {
                BlockState state = level.getBlockState(pos);
                ILeaveslikeBlock leavesLike = ClassUtil.getLeaveslikeBlock(state.getBlock());
                if (leavesLike != null) {
                    leavesLike.fell((Player)player, (Level)level, (BlockPos)pos, state);
                } else if (tryToDecay && FellTreeResult.shouldDecayLeaves(state)) {
                    FellTreeResult.decayLeavesInsteadOfBreaking(level, pos, state);
                } else {
                    blockBreaker.accept((BlockPos)pos);
                }
                if (effects.isEmpty() || player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) > 9.0) {
                    FellTreeResult.collectSomeBlocks(effects, pos, state, i, 8);
                }
            }
        };
        tree.forEachLeaves(leavesBreaker);
        effects.stream().limit(5L).forEach(posState -> FellTreeResult.playBlockBreakEffects((Level)level, (BlockPos)posState.getLeft(), (BlockState)posState.getRight()));
    }

    private static void collectSomeBlocks(Queue<Pair<BlockPos, BlockState>> collection, BlockPos pos, BlockState state, AtomicInteger counter, int period) {
        if (counter.getAndIncrement() % period == 0) {
            collection.add((Pair<BlockPos, BlockState>)Pair.of((Object)pos, (Object)state));
        }
    }

    private static void playBlockBreakEffects(Level level, BlockPos pos, BlockState state) {
        level.levelEvent(2001, pos, Block.getId((BlockState)state));
    }

    private static void decayLeavesInsteadOfBreaking(ServerLevel level, BlockPos pos, BlockState state) {
        BlockState decayingState = (BlockState)((BlockState)state.setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(false))).setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(7));
        decayingState.randomTick(level, pos, level.random);
    }

    private static boolean shouldDecayLeaves(BlockState blockState) {
        return blockState.hasProperty((Property)LeavesBlock.DISTANCE) && blockState.hasProperty((Property)LeavesBlock.PERSISTENT) && ((BlockState)((BlockState)blockState.setValue((Property)LeavesBlock.DISTANCE, (Comparable)Integer.valueOf(7))).setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(false))).isRandomlyTicking();
    }
}

