/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.compat;

import ht.treechop.TreeChop;
import ht.treechop.TreeChopException;
import ht.treechop.api.TreeData;
import ht.treechop.client.Client;
import ht.treechop.common.block.ChoppedLogBlock;
import ht.treechop.common.chop.ChopUtil;
import ht.treechop.common.settings.ChopSettings;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class WailaUtil {
    @NotNull
    public static MutableComponent getPrefixedBlockName(ChoppedLogBlock.MyEntity choppedEntity) {
        String originalBlockName = Language.getInstance().getOrDefault(choppedEntity.getOriginalState().getBlock().getDescriptionId());
        return Component.translatable((String)"treechop.waila.chopped_x", (Object[])new Object[]{originalBlockName});
    }

    public static BlockState getLogState(Level level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ChoppedLogBlock.MyEntity) {
            ChoppedLogBlock.MyEntity entity = (ChoppedLogBlock.MyEntity)blockEntity;
            return entity.getOriginalState();
        }
        return state;
    }

    public static boolean playerWantsTreeInfo(Level level, BlockPos pos, boolean showTreeBlocks, boolean showNumChops) {
        if (!TreeChop.platform.isDedicatedServer()) {
            return WailaUtil.playerWantsTreeInfo(level, pos, Client.getPlayer(), Client.getChopSettings(), showTreeBlocks, showNumChops);
        }
        return false;
    }

    public static boolean playerWantsTreeInfo(Level level, BlockPos pos, Player player, ChopSettings chopSettings, boolean showTreeBlocks, boolean showNumChops) {
        return ChopUtil.playerWantsToChop(player, chopSettings) && ChopUtil.isBlockChoppable((BlockGetter)level, pos, level.getBlockState(pos)) && (showTreeBlocks || showNumChops);
    }

    public static void addTreeInfo(Level level, BlockPos pos, boolean showTreeBlocks, boolean showNumChops, Consumer<Component> addNumChops, Consumer<ItemStack> addTreeBlockStack) {
        try {
            WailaUtil.addTreeInfoOrCrash(level, pos, showTreeBlocks, showNumChops, addNumChops, addTreeBlockStack);
        }
        catch (TreeChopException e) {
            TreeChop.cry(e);
        }
    }

    public static void addTreeInfoOrCrash(Level level, BlockPos pos, boolean showTreeBlocks, boolean showNumChops, Consumer<Component> addNumChops, Consumer<ItemStack> addTreeBlockStack) throws TreeChopException {
        try {
            TreeData tree = Client.treeCache.getTree(level, pos);
            if (tree.isAProperTree(Client.getChopSettings().getTreesMustHaveLeaves())) {
                if (showNumChops) {
                    addNumChops.accept((Component)Component.translatable((String)"treechop.waila.x_out_of_y_chops", (Object[])new Object[]{tree.getChops(), ChopUtil.numChopsToFell(level, tree.streamLogs())}));
                }
                if (showTreeBlocks) {
                    tree.streamLogs().collect(Collectors.groupingBy(pos2 -> {
                        BlockState state = level.getBlockState(pos2);
                        return state.getBlock().getCloneItemStack((LevelReader)level, pos2, state).getItem();
                    }, Collectors.counting())).forEach((item, count) -> {
                        ItemStack stack = item.getDefaultInstance();
                        stack.setCount(count.intValue());
                        addTreeBlockStack.accept(stack);
                    });
                }
            }
        }
        catch (Exception e) {
            throw new TreeChopException(String.format("Parameters: %s, %s, %s, %s", level, pos, showTreeBlocks, showNumChops), e);
        }
    }
}

