/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.compat;

import ht.treechop.TreeChop;
import ht.treechop.common.block.ChoppedLogBlock;
import ht.treechop.compat.WailaUtil;
import java.util.Optional;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IClientRegistrar;
import mcp.mobius.waila.api.ICommonRegistrar;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.IWailaClientPlugin;
import mcp.mobius.waila.api.IWailaCommonPlugin;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.api.component.ItemComponent;
import mcp.mobius.waila.api.component.WrappedComponent;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class Wthit
implements IWailaCommonPlugin,
IWailaClientPlugin,
IBlockComponentProvider {
    public static final ResourceLocation SHOW_TREE_BLOCKS = TreeChop.resource("show_tree_block_counts");
    public static final ResourceLocation SHOW_NUM_CHOPS_REMAINING = TreeChop.resource("show_num_chops_remaining");
    private static final Wthit INSTANCE = new Wthit();

    public void register(ICommonRegistrar registrar) {
        registrar.featureConfig(SHOW_TREE_BLOCKS, true);
        registrar.featureConfig(SHOW_NUM_CHOPS_REMAINING, true);
    }

    public void register(IClientRegistrar registrar) {
        registrar.body((IBlockComponentProvider)INSTANCE, Block.class);
        registrar.head((IBlockComponentProvider)INSTANCE, Block.class);
    }

    public void appendHead(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof ChoppedLogBlock.MyEntity) {
            ChoppedLogBlock.MyEntity entity = (ChoppedLogBlock.MyEntity)blockEntity;
            Wthit.changeBlockName(tooltip, entity);
        }
    }

    private static void changeBlockName(ITooltip tooltip, ChoppedLogBlock.MyEntity entity) {
        String prefixedBlockName = WailaUtil.getPrefixedBlockName(entity).getString();
        Component newNameComponent = IWailaConfig.get().getFormatter().blockName((Object)prefixedBlockName);
        tooltip.setLine(WailaConstants.OBJECT_NAME_TAG, newNameComponent);
    }

    public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        boolean showChopsRemaining;
        boolean showNumBlocks;
        BlockPos pos;
        Level level = accessor.getWorld();
        if (WailaUtil.playerWantsTreeInfo(level, pos = accessor.getPosition(), showNumBlocks = config.getBoolean(SHOW_TREE_BLOCKS), showChopsRemaining = config.getBoolean(SHOW_NUM_CHOPS_REMAINING))) {
            Optional line = Optional.empty();
            WailaUtil.addTreeInfo(level, pos, showNumBlocks, showChopsRemaining, chopsComp -> tooltip.addLine((ITooltipComponent)new WrappedComponent(chopsComp)), stack -> line.orElseGet(() -> ((ITooltip)tooltip).addLine()).with((ITooltipComponent)new ItemComponent(stack)));
        }
    }
}

