/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.mixin;

import ht.treechop.TreeChopException;
import ht.treechop.api.TreeData;
import ht.treechop.client.Client;
import ht.treechop.client.gui.screen.ChopIndicator;
import ht.treechop.common.chop.ChopUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MultiPlayerGameMode.class})
public abstract class MultiPlayerGameModeMixin {
    @Shadow(remap=false)
    @Final
    private Minecraft minecraft;

    @Shadow(remap=false)
    public abstract boolean isServerControlledInventory();

    @Inject(method={"destroyBlock"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void dontPredictBlockBreak(BlockPos pos, CallbackInfoReturnable<Boolean> info) {
        try {
            LocalPlayer player = this.minecraft.player;
            ClientLevel level = this.minecraft.level;
            if (player != null && level != null && ChopUtil.playerWantsToChop((Player)player, Client.getChopSettings()) && ChopIndicator.blockCanBeChopped(pos)) {
                TreeData tree = Client.treeCache.getTree((Level)level, pos);
                BlockState state = level.getBlockState(pos);
                boolean felled = tree.readyToFell(tree.getChops() + ChopUtil.getNumChopsByTool(player.getMainHandItem(), state));
                if (!felled) {
                    ChopUtil.thwack((Player)player, (Level)level, pos, state);
                    info.setReturnValue((Object)false);
                }
            }
        }
        catch (TreeChopException treeChopException) {
            // empty catch block
        }
    }
}

