/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbxmodcompat.neoforge.ftbquests.kubejs;

import dev.architectury.event.EventResult;
import dev.ftb.mods.ftbquests.api.event.CustomFilterDisplayItemsEvent;
import dev.ftb.mods.ftbquests.events.CustomRewardEvent;
import dev.ftb.mods.ftbquests.events.CustomTaskEvent;
import dev.ftb.mods.ftbquests.events.ObjectCompletedEvent;
import dev.ftb.mods.ftbquests.events.ObjectStartedEvent;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbxmodcompat.FTBXModCompat;
import dev.ftb.mods.ftbxmodcompat.kubejs.KJSUtil;
import dev.ftb.mods.ftbxmodcompat.neoforge.ftbquests.kubejs.CustomFilterItemKubeEvent;
import dev.ftb.mods.ftbxmodcompat.neoforge.ftbquests.kubejs.CustomRewardKubeEvent;
import dev.ftb.mods.ftbxmodcompat.neoforge.ftbquests.kubejs.CustomTaskKubeEvent;
import dev.ftb.mods.ftbxmodcompat.neoforge.ftbquests.kubejs.FTBQuestsKubeJSEvents;
import dev.ftb.mods.ftbxmodcompat.neoforge.ftbquests.kubejs.FTBQuestsKubeJSPlayerData;
import dev.ftb.mods.ftbxmodcompat.neoforge.ftbquests.kubejs.FTBQuestsKubeJSWrapper;
import dev.ftb.mods.ftbxmodcompat.neoforge.ftbquests.kubejs.QuestObjectCompletedKubeEvent;
import dev.ftb.mods.ftbxmodcompat.neoforge.ftbquests.kubejs.QuestObjectStartedKubeEvent;
import dev.latvian.mods.kubejs.event.EventGroupRegistry;
import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugin;
import dev.latvian.mods.kubejs.script.BindingRegistry;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.ScriptTypeHolder;
import dev.latvian.mods.kubejs.util.AttachedData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;

public class FTBQuestsKubeJSPlugin
implements KubeJSPlugin {
    public void init() {
        CustomTaskEvent.EVENT.register(FTBQuestsKubeJSPlugin::onCustomTask);
        CustomRewardEvent.EVENT.register(FTBQuestsKubeJSPlugin::onCustomReward);
        ObjectCompletedEvent.GENERIC.register(FTBQuestsKubeJSPlugin::onCompleted);
        ObjectStartedEvent.GENERIC.register(FTBQuestsKubeJSPlugin::onStarted);
        CustomFilterDisplayItemsEvent.ADD_ITEMSTACK.register(FTBQuestsKubeJSPlugin::onCustomFilterItem);
        FTBXModCompat.LOGGER.info("[FTB Quests] Enabled KubeJS integration");
    }

    public void registerBindings(BindingRegistry bindings) {
        bindings.add("FTBQuests", (Object)FTBQuestsKubeJSWrapper.INSTANCE);
    }

    public void attachPlayerData(AttachedData<Player> event) {
        event.add("ftbquests", (Object)new FTBQuestsKubeJSPlayerData((Player)event.getParent()));
    }

    public void registerEvents(EventGroupRegistry registry) {
        registry.register(FTBQuestsKubeJSEvents.EVENT_GROUP);
    }

    private static void onCustomFilterItem(CustomFilterDisplayItemsEvent event) {
        FTBQuestsKubeJSEvents.CUSTOM_FILTER_ITEM.post((ScriptTypeHolder)ScriptType.CLIENT, (KubeEvent)new CustomFilterItemKubeEvent(event));
    }

    public static EventResult onCustomTask(CustomTaskEvent event) {
        return KJSUtil.asArchResult(FTBQuestsKubeJSEvents.CUSTOM_TASK.post((ScriptTypeHolder)ScriptType.SERVER, (Object)event.getTask().toString(), (KubeEvent)new CustomTaskKubeEvent(event)));
    }

    public static EventResult onCustomReward(CustomRewardEvent event) {
        return KJSUtil.asArchResult(FTBQuestsKubeJSEvents.CUSTOM_REWARD.post((ScriptTypeHolder)ScriptType.SERVER, (Object)event.getReward().toString(), (KubeEvent)new CustomRewardKubeEvent(event)));
    }

    public static EventResult onCompleted(ObjectCompletedEvent<?> event) {
        if (event.getData().getFile().isServerSide()) {
            QuestObjectCompletedKubeEvent kjsEvent = new QuestObjectCompletedKubeEvent(event);
            QuestObject object = event.getObject();
            FTBQuestsKubeJSEvents.OBJECT_COMPLETED.post((ScriptTypeHolder)ScriptType.SERVER, (Object)event.getObject().toString(), (KubeEvent)kjsEvent);
            for (String tag : object.getTags()) {
                FTBQuestsKubeJSEvents.OBJECT_COMPLETED.post((ScriptTypeHolder)ScriptType.SERVER, (Object)("#" + tag), (KubeEvent)kjsEvent);
            }
        }
        return EventResult.pass();
    }

    public static EventResult onStarted(ObjectStartedEvent<?> event) {
        if (event.getData().getFile().isServerSide()) {
            QuestObjectStartedKubeEvent kjsEvent = new QuestObjectStartedKubeEvent(event);
            QuestObject object = event.getObject();
            FTBQuestsKubeJSEvents.OBJECT_STARTED.post((ScriptTypeHolder)ScriptType.SERVER, (Object)event.getObject().toString(), (KubeEvent)kjsEvent);
            for (String tag : object.getTags()) {
                FTBQuestsKubeJSEvents.OBJECT_STARTED.post((ScriptTypeHolder)ScriptType.SERVER, (Object)("#" + tag), (KubeEvent)kjsEvent);
            }
        }
        return EventResult.pass();
    }

    static MinecraftServer getServer(QuestObjectBase qo) {
        BaseQuestFile baseQuestFile = qo.getQuestFile();
        if (baseQuestFile instanceof ServerQuestFile) {
            ServerQuestFile sqf = (ServerQuestFile)baseQuestFile;
            return sqf.server;
        }
        throw new IllegalStateException("only use this on the server!");
    }
}

