/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.compat;

import com.google.common.collect.ImmutableList;
import dev.shadowsoffire.apothic_enchanting.ApothicEnchanting;
import dev.shadowsoffire.apothic_enchanting.Ench;
import dev.shadowsoffire.apothic_enchanting.compat.InfusionRecipeCategory;
import dev.shadowsoffire.apothic_enchanting.table.infusion.InfusionRecipe;
import dev.shadowsoffire.apothic_enchanting.util.TooltipUtil;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

@JeiPlugin
public class EnchJEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return ApothicEnchanting.loc("enchantment");
    }

    public void registerRecipes(IRecipeRegistration reg) {
        Registry enchants = Minecraft.getInstance().level.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        Holder randomEnch = enchants.getRandomElementOf(EnchantmentTags.IN_ENCHANTING_TABLE, Minecraft.getInstance().level.random).orElse((Holder)enchants.getAny().get());
        Holder randomCurse = enchants.getRandomElementOf(EnchantmentTags.CURSE, Minecraft.getInstance().level.random).orElse((Holder)enchants.getAny().get());
        ItemStack enchDiaSword = new ItemStack((ItemLike)Items.DIAMOND_SWORD);
        enchDiaSword.enchant(randomEnch, 1);
        ItemStack cursedDiaSword = new ItemStack((ItemLike)Items.DIAMOND_SWORD);
        cursedDiaSword.enchant(randomCurse, 1);
        ItemStack enchBook = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
        enchDiaSword.enchant(randomEnch, 1);
        IVanillaRecipeFactory factory = reg.getVanillaRecipeFactory();
        reg.addRecipes(RecipeTypes.ANVIL, (List)ImmutableList.of((Object)factory.createAnvilRecipe(cursedDiaSword, (List)ImmutableList.of((Object)new ItemStack(Ench.Items.PRISMATIC_WEB)), (List)ImmutableList.of((Object)new ItemStack((ItemLike)Items.DIAMOND_SWORD)), ApothicEnchanting.loc("prismatic_cobweb")), (Object)factory.createAnvilRecipe(enchDiaSword, (List)ImmutableList.of((Object)new ItemStack(Ench.Items.SCRAP_TOME)), (List)ImmutableList.of((Object)enchBook), ApothicEnchanting.loc("scrap_tome")), (Object)factory.createAnvilRecipe(new ItemStack((ItemLike)Blocks.DAMAGED_ANVIL), (List)ImmutableList.of((Object)new ItemStack((ItemLike)Blocks.IRON_BLOCK)), (List)ImmutableList.of((Object)new ItemStack((ItemLike)Blocks.ANVIL)), ApothicEnchanting.loc("anvil_repair"))));
        reg.addIngredientInfo((Object)new ItemStack((ItemLike)Items.ENCHANTING_TABLE), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TooltipUtil.lang("info", "enchanting", new Object[0])});
        reg.addIngredientInfo((Object)new ItemStack(Ench.Items.LIBRARY), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{TooltipUtil.lang("info", "library", new Object[0])});
        List<InfusionRecipe> recipes = Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor(Ench.RecipeTypes.INFUSION).stream().map(RecipeHolder::value).sorted((r1, r2) -> Float.compare(r1.getRequirements().eterna(), r2.getRequirements().eterna())).toList();
        reg.addRecipes(InfusionRecipeCategory.TYPE, recipes);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration reg) {
        reg.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.ENCHANTING_TABLE), new RecipeType[]{InfusionRecipeCategory.TYPE});
    }

    public void registerCategories(IRecipeCategoryRegistration reg) {
        reg.addRecipeCategories(new IRecipeCategory[]{new InfusionRecipeCategory(reg.getJeiHelpers().getGuiHelper())});
    }
}

