/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting.enchantments;

import dev.shadowsoffire.apothic_enchanting.ApothicEnchanting;
import dev.shadowsoffire.apothic_enchanting.Ench;
import dev.shadowsoffire.apothic_enchanting.util.MiscUtil;
import dev.shadowsoffire.placebo.util.PlaceboTaskQueue;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.level.BlockEvent;

public class ChainsawTask
implements PlaceboTaskQueue.Task {
    UUID owner;
    ItemStack axe;
    ServerLevel level;
    Int2ObjectMap<Queue<BlockPos>> hits = new Int2ObjectOpenHashMap();
    int ticks = 0;

    private ChainsawTask(UUID owner, ItemStack axe, Level level, BlockPos pos) {
        this.owner = owner;
        this.axe = axe;
        this.level = (ServerLevel)level;
        ((Queue)this.hits.computeIfAbsent(pos.getY(), i -> new ArrayDeque())).add(pos);
    }

    public PlaceboTaskQueue.Status execute() {
        if (++this.ticks % 2 != 0) {
            return PlaceboTaskQueue.Status.RUNNING;
        }
        if (this.axe.isEmpty()) {
            return PlaceboTaskQueue.Status.COMPLETED;
        }
        int minY = this.hits.keySet().intStream().min().getAsInt();
        Queue queue = (Queue)this.hits.get(minY);
        int breaks = 0;
        while (!queue.isEmpty()) {
            BlockPos pos = (BlockPos)queue.poll();
            for (BlockPos p : BlockPos.betweenClosed((BlockPos)pos.offset(-1, 0, -1), (BlockPos)pos.offset(1, 1, 1))) {
                BlockState state;
                if (p.equals((Object)pos) || !(state = this.level.getBlockState(p)).is(BlockTags.LOGS)) continue;
                MiscUtil.breakExtraBlock(this.level, p, this.axe, this.owner);
                if (this.level.getBlockState(p).is(BlockTags.LOGS)) continue;
                ((Queue)this.hits.computeIfAbsent(p.getY(), i -> new ArrayDeque())).add(p.immutable());
                ++breaks;
            }
            if (breaks <= 5) continue;
            break;
        }
        if (queue.isEmpty()) {
            this.hits.remove(minY);
        }
        return this.hits.isEmpty() ? PlaceboTaskQueue.Status.COMPLETED : PlaceboTaskQueue.Status.RUNNING;
    }

    public static void attemptChainsaw(BlockEvent.BreakEvent e) {
        Player player = e.getPlayer();
        Level level = player.level();
        ItemStack stack = player.getMainHandItem();
        boolean hasChainsaw = EnchantmentHelper.has((ItemStack)stack, Ench.EnchantEffects.CHAINSAW);
        if (player.getClass() == ServerPlayer.class && hasChainsaw && !level.isClientSide && ChainsawTask.isTree(level, e.getPos(), e.getState()) && !player.getAbilities().instabuild) {
            PlaceboTaskQueue.submitTask((ResourceLocation)ApothicEnchanting.loc("chainsaw_task"), (PlaceboTaskQueue.Task)new ChainsawTask(player.getUUID(), stack, level, e.getPos()));
        }
    }

    private static boolean isTree(Level level, BlockPos pos, BlockState state) {
        if (!state.is(BlockTags.LOGS)) {
            return false;
        }
        while (state.is(BlockTags.LOGS)) {
            pos = pos.above();
            state = level.getBlockState(pos);
        }
        for (BlockPos p : BlockPos.betweenClosed((BlockPos)pos.offset(-2, -2, -2), (BlockPos)pos.offset(2, 2, 2))) {
            if (!level.getBlockState(p).is(BlockTags.LEAVES)) continue;
            return true;
        }
        return false;
    }
}

