/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.capture;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.client.util.Minecrft;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaptureShader {
    @Nullable
    private static PostChain shader = null;

    public static boolean hasShader() {
        return shader != null;
    }

    public static void apply(ResourceLocation shaderLocation) {
        if (shader != null) {
            if (shader.getName().equals(shaderLocation.toString())) {
                return;
            }
            shader.close();
        }
        try {
            Minecraft minecraft = Minecrft.get();
            shader = new PostChain(minecraft.getTextureManager(), (ResourceProvider)minecraft.getResourceManager(), minecraft.getMainRenderTarget(), shaderLocation);
            shader.resize(minecraft.getWindow().getWidth(), minecraft.getWindow().getHeight());
        }
        catch (IOException e) {
            Exposure.LOGGER.warn("Failed to load shader: {}", (Object)shaderLocation, (Object)e);
            CaptureShader.remove();
        }
        catch (JsonSyntaxException e) {
            Exposure.LOGGER.warn("Failed to parse shader: {}", (Object)shaderLocation, (Object)e);
            CaptureShader.remove();
        }
    }

    public static void resize(int width, int height) {
        if (shader != null) {
            shader.resize(width, height);
        }
    }

    public static void process() {
        if (shader != null) {
            RenderSystem.disableBlend();
            RenderSystem.disableDepthTest();
            RenderSystem.resetTextureMatrix();
            shader.process(Minecrft.get().getTimer().getGameTimeDeltaTicks());
        }
    }

    public static void process(RenderTarget renderTarget) {
        if (shader != null) {
            CaptureShader.process(shader, renderTarget);
        }
    }

    public static void process(@NotNull PostChain shader, @NotNull RenderTarget renderTarget) {
        try {
            ResourceLocation shaderLocation = ResourceLocation.parse((String)shader.getName());
            PostChain tempShader = new PostChain(Minecrft.get().getTextureManager(), (ResourceProvider)Minecrft.get().getResourceManager(), renderTarget, shaderLocation);
            tempShader.resize(renderTarget.width, renderTarget.height);
            RenderSystem.disableBlend();
            RenderSystem.disableDepthTest();
            RenderSystem.resetTextureMatrix();
            tempShader.process(Minecrft.get().getTimer().getGameTimeDeltaTicks());
            tempShader.close();
        }
        catch (IOException e) {
            Exposure.LOGGER.warn("Failed to load shader: {}", (Object)shader.getName(), (Object)e);
        }
        catch (JsonSyntaxException e) {
            Exposure.LOGGER.warn("Failed to parse shader: {}", (Object)shader.getName(), (Object)e);
        }
    }

    public static void remove() {
        if (shader != null) {
            shader.close();
        }
        shader = null;
    }
}

