/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.capture.action;

import io.github.mortuusars.exposure.client.capture.action.CaptureAction;
import java.util.Arrays;
import java.util.List;

public class CompositeAction
implements CaptureAction {
    private final List<CaptureAction> actions;

    public CompositeAction(CaptureAction ... actions) {
        this.actions = Arrays.stream(actions).filter(action -> !action.equals(CaptureAction.EMPTY)).toList();
    }

    public List<CaptureAction> getActions() {
        return this.actions;
    }

    @Override
    public int requiredDelayTicks() {
        return this.actions.stream().mapToInt(CaptureAction::requiredDelayTicks).max().orElse(0);
    }

    @Override
    public void initialize() {
        this.actions.forEach(CaptureAction::initialize);
    }

    @Override
    public void delayTick(int delayTicksLeft) {
        this.actions.forEach(component -> component.delayTick(delayTicksLeft));
    }

    @Override
    public void beforeCapture() {
        this.actions.forEach(CaptureAction::beforeCapture);
    }

    @Override
    public void afterCapture() {
        this.actions.forEach(CaptureAction::afterCapture);
    }
}

