/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.gui.toast;

import io.github.mortuusars.exposure.client.gui.toast.ToastIcon;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BetterTutorialToast
implements Toast {
    private static final ResourceLocation BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"toast/tutorial");
    public static final int DEFAULT_SHOW_DURATION_MS = 7000;
    public ResourceLocation backgroundSprite = BACKGROUND_SPRITE;
    public Runnable onHide;
    protected final ToastIcon icon;
    protected final Component title;
    @Nullable
    protected final Component message;
    protected Toast.Visibility visibility;
    protected final long shownAt;
    protected final int showDurationMs;
    protected final Supplier<Boolean> hideIf;

    public BetterTutorialToast(ToastIcon icon, Component title, @Nullable Component message, int showDurationMs, Supplier<Boolean> hideIf) {
        this.onHide = () -> {};
        this.visibility = Toast.Visibility.SHOW;
        this.shownAt = System.currentTimeMillis();
        this.icon = icon;
        this.title = title;
        this.message = message;
        this.showDurationMs = showDurationMs;
        this.hideIf = hideIf;
    }

    public BetterTutorialToast(ToastIcon icon, Component title, @Nullable Component message, int showDurationMs) {
        this.onHide = () -> {};
        this.visibility = Toast.Visibility.SHOW;
        this.shownAt = System.currentTimeMillis();
        this.icon = icon;
        this.title = title;
        this.message = message;
        this.showDurationMs = showDurationMs;
        this.hideIf = () -> false;
    }

    public BetterTutorialToast(ToastIcon icon, Component title, @Nullable Component message, Supplier<Boolean> hideIf) {
        this.onHide = () -> {};
        this.visibility = Toast.Visibility.SHOW;
        this.shownAt = System.currentTimeMillis();
        this.icon = icon;
        this.title = title;
        this.message = message;
        this.showDurationMs = -1;
        this.hideIf = hideIf;
    }

    public void hide() {
        this.visibility = Toast.Visibility.HIDE;
    }

    @NotNull
    public Toast.Visibility render(GuiGraphics guiGraphics, ToastComponent toastComponent, long timeSinceLastVisible) {
        if (this.visibility == Toast.Visibility.SHOW && this.hideIf.get().booleanValue() || this.showDurationMs > 0 && System.currentTimeMillis() > this.shownAt + (long)this.showDurationMs) {
            this.hide();
            this.onHide.run();
        }
        guiGraphics.blitSprite(this.backgroundSprite, 0, 0, this.width(), this.height());
        this.icon.render(guiGraphics, 6, 6);
        if (this.message == null) {
            guiGraphics.drawString(toastComponent.getMinecraft().font, this.title, 30, 12, -11534256, false);
        } else {
            guiGraphics.drawString(toastComponent.getMinecraft().font, this.title, 30, 7, -11534256, false);
            guiGraphics.drawString(toastComponent.getMinecraft().font, this.message, 30, 18, -16777216, false);
        }
        return this.visibility;
    }
}

