/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.image.modifier.pixel;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.client.image.modifier.pixel.PixelEffect;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class ColorBalanceEffect
implements PixelEffect {
    protected final float r;
    protected final float g;
    protected final float b;

    public ColorBalanceEffect(float r, float g, float b) {
        Preconditions.checkArgument((r >= -1.0f && r <= 1.0f ? 1 : 0) != 0, (Object)"r must be in -1 to 1 range.");
        Preconditions.checkArgument((g >= -1.0f && g <= 1.0f ? 1 : 0) != 0, (Object)"g must be in -1 to 1 range.");
        Preconditions.checkArgument((b >= -1.0f && b <= 1.0f ? 1 : 0) != 0, (Object)"b must be in -1 to 1 range.");
        this.r = r;
        this.g = g;
        this.b = b;
    }

    @Override
    public String getIdentifier() {
        return "color-balance-r%s-g%s-b%s".formatted(Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b));
    }

    @Override
    public int modify(int colorARGB) {
        if (this.r == 0.0f && this.g == 0.0f && this.b == 0.0f) {
            return colorARGB;
        }
        int alpha = FastColor.ARGB32.alpha((int)colorARGB);
        int red = FastColor.ARGB32.red((int)colorARGB);
        int green = FastColor.ARGB32.green((int)colorARGB);
        int blue = FastColor.ARGB32.blue((int)colorARGB);
        red = Mth.clamp((int)Mth.floor((float)((float)red * (this.r + 1.0f))), (int)0, (int)255);
        green = Mth.clamp((int)Mth.floor((float)((float)green * (this.g + 1.0f))), (int)0, (int)255);
        blue = Mth.clamp((int)Mth.floor((float)((float)blue * (this.b + 1.0f))), (int)0, (int)255);
        return FastColor.ARGB32.color((int)alpha, (int)red, (int)green, (int)blue);
    }

    public String toString() {
        return "ColorBalance{r=" + this.r + ", g=" + this.g + ", b=" + this.b + "}";
    }
}

