/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.item;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.data.ColorPalette;
import io.github.mortuusars.exposure.data.ColorPalettes;
import io.github.mortuusars.exposure.world.camera.capture.DitherMode;
import io.github.mortuusars.exposure.world.camera.film.properties.ColorBalance;
import io.github.mortuusars.exposure.world.camera.film.properties.FilmProperties;
import io.github.mortuusars.exposure.world.camera.film.properties.FilmStyle;
import io.github.mortuusars.exposure.world.camera.film.properties.HSB;
import io.github.mortuusars.exposure.world.camera.film.properties.Levels;
import io.github.mortuusars.exposure.world.item.FilmItem;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SensitiveFilmItem
extends FilmItem {
    @NotNull
    default public FilmProperties getFilmProperties(ItemStack stack) {
        return new FilmProperties(this.getType(), Optional.of(this.getFrameSize(stack)), this.getColorPalette(stack), this.getDitherMode(stack), this.getFilmStyle(stack));
    }

    @NotNull
    default public FilmStyle getFilmStyle(ItemStack stack) {
        return (FilmStyle)stack.getOrDefault(Exposure.DataComponents.FILM_STYLE, (Object)FilmStyle.EMPTY);
    }

    default public ResourceKey<ColorPalette> getColorPalette(ItemStack stack) {
        @Nullable ResourceLocation location = (ResourceLocation)stack.get(Exposure.DataComponents.FILM_COLOR_PALETTE);
        if (location != null) {
            return ColorPalettes.createKey(location);
        }
        return ColorPalettes.DEFAULT;
    }

    @NotNull
    default public DitherMode getDitherMode(ItemStack stack) {
        return (DitherMode)((Object)stack.getOrDefault(Exposure.DataComponents.FILM_DITHER_MODE, (Object)DitherMode.DITHERED));
    }

    default public void addFrameSizeToTooltip(ItemStack stack, List<Component> list) {
        int frameSize = this.getFrameSize(stack);
        if (frameSize != this.getDefaultFrameSize(stack)) {
            list.add((Component)Component.translatable((String)"item.exposure.film_roll.tooltip.frame_size", (Object[])new Object[]{Component.literal((String)String.format("%.1f", Float.valueOf((float)frameSize / 10.0f)))}).withStyle(ChatFormatting.GRAY));
        }
    }

    default public void addPaletteToTooltip(ItemStack stack, List<Component> list) {
        ResourceKey<ColorPalette> palette = this.getColorPalette(stack);
        if (!palette.equals(ColorPalettes.DEFAULT)) {
            list.add((Component)Component.translatable((String)"item.exposure.film_roll.tooltip.palette", (Object[])new Object[]{palette.location().toString()}).withStyle(ChatFormatting.DARK_GRAY));
        }
    }

    default public void addStyleToTooltip(ItemStack stack, List<Component> list) {
        FilmStyle style = this.getFilmStyle(stack);
        if (style.sensitivity().floatValue() != 0.0f) {
            list.add((Component)Component.translatable((String)"item.exposure.film_roll.tooltip.sensitivity", (Object[])new Object[]{style.sensitivity()}).withStyle(ChatFormatting.DARK_GRAY));
        }
        if (style.contrast().floatValue() != 0.0f) {
            list.add((Component)Component.translatable((String)"item.exposure.film_roll.tooltip.contrast", (Object[])new Object[]{style.contrast()}).withStyle(ChatFormatting.DARK_GRAY));
        }
        if (style.levels() != Levels.EMPTY) {
            list.add((Component)Component.translatable((String)"item.exposure.film_roll.tooltip.levels", (Object[])new Object[]{style.levels().toString()}).withStyle(ChatFormatting.DARK_GRAY));
        }
        if (style.hsb() != HSB.EMPTY) {
            list.add((Component)Component.translatable((String)"item.exposure.film_roll.tooltip.hsb", (Object[])new Object[]{style.hsb().toString()}).withStyle(ChatFormatting.DARK_GRAY));
        }
        if (style.colorBalance() != ColorBalance.EMPTY) {
            list.add((Component)Component.translatable((String)"item.exposure.film_roll.tooltip.color_balance", (Object[])new Object[]{style.colorBalance().toString()}).withStyle(ChatFormatting.DARK_GRAY));
        }
        if (style.noise().floatValue() != 0.0f) {
            list.add((Component)Component.translatable((String)"item.exposure.film_roll.tooltip.noise", (Object[])new Object[]{style.noise()}).withStyle(ChatFormatting.DARK_GRAY));
        }
    }
}

