/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.item.component;

import com.mojang.serialization.Codec;
import io.github.mortuusars.exposure.world.item.util.ItemAndStack;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class StoredItemStack {
    public static final StoredItemStack EMPTY = new StoredItemStack(ItemStack.EMPTY);
    public static final Codec<StoredItemStack> CODEC = ItemStack.CODEC.xmap(StoredItemStack::new, StoredItemStack::getForReading);
    public static final StreamCodec<RegistryFriendlyByteBuf, StoredItemStack> STREAM_CODEC = ItemStack.STREAM_CODEC.map(StoredItemStack::new, StoredItemStack::getForReading);
    private final ItemStack stack;

    public StoredItemStack(ItemStack stack) {
        this.stack = stack;
    }

    public ItemStack getForReading() {
        return this.stack;
    }

    public ItemStack getCopy() {
        return this.stack.copy();
    }

    public <T extends Item> ItemAndStack<T> getItemAndStackCopy() {
        return new ItemAndStack(this.getCopy());
    }

    public Item getItem() {
        return this.getForReading().getItem();
    }

    public boolean isEmpty() {
        return this.getForReading().isEmpty();
    }

    public <T, R> Optional<R> mapIf(Class<T> clazz, BiFunction<T, ItemStack, R> func) {
        if (this.getForReading().getItem().getClass().equals(clazz)) {
            return Optional.ofNullable(func.apply(clazz.cast(this.getForReading().getItem()), this.getForReading()));
        }
        return Optional.empty();
    }

    public boolean equals(Object obj) {
        if (obj instanceof StoredItemStack) {
            StoredItemStack other = (StoredItemStack)obj;
            return ItemStack.isSameItemSameComponents((ItemStack)this.getForReading(), (ItemStack)other.getForReading());
        }
        return false;
    }

    public int hashCode() {
        return ItemStack.hashItemAndComponents((ItemStack)this.getForReading());
    }

    public String toString() {
        return "ItemStackBox{stack=" + String.valueOf(this.getForReading()) + "}";
    }
}

