/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.api;

import java.util.OptionalInt;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import owmii.powah.api.FluidCoolantConfig;
import owmii.powah.api.MagmatorFuelValue;
import owmii.powah.api.PassiveHeatSourceConfig;
import owmii.powah.api.SolidCoolantConfig;

public class PowahAPI {
    private PowahAPI() {
    }

    public static int getMagmaticFluidEnergyProduced(Fluid fluid) {
        MagmatorFuelValue config = (MagmatorFuelValue)BuiltInRegistries.FLUID.getData(MagmatorFuelValue.DATA_MAP_TYPE, fluid.builtInRegistryHolder().key());
        if (config == null) {
            return 0;
        }
        return config.energyProduced();
    }

    public static OptionalInt getCoolant(Fluid fluid) {
        FluidCoolantConfig config = (FluidCoolantConfig)BuiltInRegistries.FLUID.getData(FluidCoolantConfig.DATA_MAP_TYPE, fluid.builtInRegistryHolder().key());
        if (config == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(config.temperature());
    }

    public static int getHeatSource(Block block) {
        PassiveHeatSourceConfig config = (PassiveHeatSourceConfig)BuiltInRegistries.BLOCK.getData(PassiveHeatSourceConfig.BLOCK_DATA_MAP, BuiltInRegistries.BLOCK.wrapAsHolder((Object)block).getKey());
        if (config == null) {
            return 0;
        }
        return config.temperature();
    }

    public static int getHeatSource(Fluid fluid) {
        PassiveHeatSourceConfig config = (PassiveHeatSourceConfig)BuiltInRegistries.FLUID.getData(PassiveHeatSourceConfig.FLUID_DATA_MAP, BuiltInRegistries.FLUID.wrapAsHolder((Object)fluid).getKey());
        if (config == null) {
            return 0;
        }
        return config.temperature();
    }

    public static int getHeatSource(BlockState blockState) {
        FluidState fluidState;
        int heatFromBlock = 0;
        int heatFromFluid = 0;
        if (!blockState.isEmpty()) {
            heatFromBlock = PowahAPI.getHeatSource(blockState.getBlock());
        }
        if (!(fluidState = blockState.getFluidState()).isEmpty()) {
            heatFromFluid = PowahAPI.getHeatSource((Fluid)fluidState.holder().value()) * fluidState.getAmount() / 8;
        }
        return Math.max(heatFromBlock, heatFromFluid);
    }

    public static SolidCoolantConfig getSolidCoolant(ItemLike item) {
        SolidCoolantConfig config = (SolidCoolantConfig)BuiltInRegistries.ITEM.getData(SolidCoolantConfig.DATA_MAP_TYPE, item.asItem().builtInRegistryHolder().key());
        if (config == null) {
            return new SolidCoolantConfig(0, 0);
        }
        return config;
    }
}

