/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.phys.AABB;
import owmii.powah.Powah;
import owmii.powah.block.Tier;
import owmii.powah.block.reactor.ReactorTile;
import owmii.powah.client.model.CubeModel;
import owmii.powah.client.model.PowahLayerDefinitions;
import owmii.powah.client.model.ReactorModel;
import owmii.powah.lib.client.renderer.tile.AbstractTileRenderer;

public class ReactorRenderer
extends AbstractTileRenderer<ReactorTile> {
    private final ReactorModel reactorModel;
    private final CubeModel reactorPartModel;

    protected ReactorRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        this.reactorModel = new ReactorModel(context.bakeLayer(PowahLayerDefinitions.REACTOR));
        this.reactorPartModel = new CubeModel(RenderType::entitySolid, context.bakeLayer(PowahLayerDefinitions.REACTOR_PART));
    }

    @Override
    public void render(ReactorTile te, float pt, PoseStack matrix, MultiBufferSource rtb, Minecraft mc, ClientLevel world, LocalPlayer player, int light, int ov) {
        matrix.pushPose();
        matrix.translate(0.5, 0.5, 0.5);
        matrix.scale(1.0f, -1.0f, -1.0f);
        if (!te.isBuilt()) {
            VertexConsumer buffer = rtb.getBuffer(this.reactorPartModel.renderType(Powah.id("textures/model/tile/reactor_block_" + ((Tier)te.getVariant()).getName() + ".png")));
            this.reactorPartModel.renderToBuffer(matrix, buffer, light, ov, -1);
        } else {
            matrix.translate(0.0, -1.0, 0.0);
            this.reactorModel.render(te, this, matrix, rtb, light, ov);
        }
        matrix.popPose();
    }

    public boolean shouldRenderOffScreen(ReactorTile te) {
        return te.isBuilt();
    }

    public AABB getRenderBoundingBox(ReactorTile blockEntity) {
        return new AABB(blockEntity.getBlockPos()).inflate(1.0, 3.0, 1.0);
    }
}

