/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.compat.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import owmii.powah.Powah;
import owmii.powah.compat.emi.PowahEmiCategory;
import owmii.powah.item.Itms;
import owmii.powah.recipe.ReactorFuel;

class EmiReactorFuelRecipe
implements EmiRecipe {
    public static final ResourceLocation GUI_BACK = Powah.id("textures/gui/jei/misc.png");
    public static final PowahEmiCategory CATEGORY = new PowahEmiCategory(Powah.id("reactor_fuels"), (EmiRenderable)EmiStack.of((ItemLike)((ItemLike)Itms.URANINITE.get())), (Component)Component.translatable((String)"gui.powah.jei.category.reactor.fuels"));
    private final ResourceLocation id;
    private final ReactorFuel recipe;
    private final EmiIngredient input;

    public EmiReactorFuelRecipe(ResourceLocation id, ReactorFuel fuel) {
        this.id = id;
        this.recipe = fuel;
        ItemStack stack = ((Item)BuiltInRegistries.ITEM.get(id)).getDefaultInstance();
        this.input = EmiIngredient.of((Ingredient)Ingredient.of((ItemStack[])new ItemStack[]{stack}));
    }

    public EmiRecipeCategory getCategory() {
        return CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return List.of(this.input);
    }

    public List<EmiStack> getOutputs() {
        return List.of();
    }

    public int getDisplayWidth() {
        return 158;
    }

    public int getDisplayHeight() {
        return 26;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(GUI_BACK, 0, 1, 160, 24, 0, 0);
        widgets.addSlot(this.input, 3, 4).drawBack(false);
        widgets.addText((Component)Component.translatable((String)"info.lollipop.amount").append(": ").append((Component)Component.translatable((String)"info.lollipop.mb", (Object[])new Object[]{this.recipe.fuelAmount()})), 30, 3, 0x444444, false);
        MutableComponent coloredTemperature = Component.literal((String)String.valueOf(this.recipe.temperature())).withStyle(ChatFormatting.DARK_RED);
        widgets.addText((Component)Component.translatable((String)"info.lollipop.temperature").append(": ").append((Component)Component.translatable((String)"info.lollipop.temperature.c", (Object[])new Object[]{coloredTemperature})), 30, 15, 0x444444, false);
    }
}

