/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.compat.emi;

import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiInfoRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import owmii.powah.Powah;
import owmii.powah.block.Blcks;
import owmii.powah.compat.common.FluidCoolant;
import owmii.powah.compat.common.MagmatorFuel;
import owmii.powah.compat.common.PassiveHeatSource;
import owmii.powah.compat.common.SolidCoolant;
import owmii.powah.compat.emi.EmiEnergizingRecipe;
import owmii.powah.compat.emi.EmiFluidCoolantRecipe;
import owmii.powah.compat.emi.EmiHeatSourceRecipe;
import owmii.powah.compat.emi.EmiMagmatorRecipe;
import owmii.powah.compat.emi.EmiReactorFuelRecipe;
import owmii.powah.compat.emi.EmiSolidCoolantRecipe;
import owmii.powah.item.Itms;
import owmii.powah.lib.client.screen.container.AbstractContainerScreen;
import owmii.powah.recipe.ReactorFuel;
import owmii.powah.recipe.Recipes;

@EmiEntrypoint
public class PowahEmiPlugin
implements EmiPlugin {
    public void register(EmiRegistry registry) {
        registry.addCategory((EmiRecipeCategory)EmiMagmatorRecipe.CATEGORY);
        for (Block block2 : Blcks.MAGMATOR.getAll()) {
            registry.addWorkstation((EmiRecipeCategory)EmiMagmatorRecipe.CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)block2));
        }
        registry.addCategory((EmiRecipeCategory)EmiFluidCoolantRecipe.CATEGORY);
        registry.addCategory((EmiRecipeCategory)EmiSolidCoolantRecipe.CATEGORY);
        registry.addCategory((EmiRecipeCategory)EmiHeatSourceRecipe.CATEGORY);
        registry.addCategory((EmiRecipeCategory)EmiEnergizingRecipe.CATEGORY);
        registry.addCategory((EmiRecipeCategory)EmiReactorFuelRecipe.CATEGORY);
        registry.addWorkstation((EmiRecipeCategory)EmiEnergizingRecipe.CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)Blcks.ENERGIZING_ORB.get())));
        Blcks.ENERGIZING_ROD.getAll().forEach(block -> registry.addWorkstation((EmiRecipeCategory)EmiEnergizingRecipe.CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)block)));
        Blcks.MAGMATOR.getAll().forEach(block -> registry.addWorkstation((EmiRecipeCategory)EmiMagmatorRecipe.CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)block)));
        Blcks.THERMO_GENERATOR.getAll().forEach(block -> {
            registry.addWorkstation((EmiRecipeCategory)EmiHeatSourceRecipe.CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)block));
            registry.addWorkstation((EmiRecipeCategory)EmiFluidCoolantRecipe.CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)block));
        });
        Blcks.REACTOR.getAll().forEach(block -> {
            registry.addWorkstation((EmiRecipeCategory)EmiSolidCoolantRecipe.CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)block));
            registry.addWorkstation((EmiRecipeCategory)EmiFluidCoolantRecipe.CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)block));
            registry.addWorkstation((EmiRecipeCategory)EmiReactorFuelRecipe.CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)block));
        });
        PowahEmiPlugin.adaptRecipeType(registry, Recipes.ENERGIZING.get(), EmiEnergizingRecipe::new);
        for (Map.Entry entry : BuiltInRegistries.ITEM.getDataMap(ReactorFuel.DATA_MAP_TYPE).entrySet()) {
            registry.addRecipe((EmiRecipe)new EmiReactorFuelRecipe(((ResourceKey)entry.getKey()).location(), (ReactorFuel)entry.getValue()));
        }
        MagmatorFuel.getAll().forEach(recipe -> registry.addRecipe((EmiRecipe)new EmiMagmatorRecipe((MagmatorFuel)recipe)));
        FluidCoolant.getAll().forEach(recipe -> registry.addRecipe((EmiRecipe)new EmiFluidCoolantRecipe((FluidCoolant)recipe)));
        SolidCoolant.getAll().forEach(recipe -> registry.addRecipe((EmiRecipe)new EmiSolidCoolantRecipe((SolidCoolant)recipe)));
        PassiveHeatSource.getAll().forEach(recipe -> registry.addRecipe((EmiRecipe)new EmiHeatSourceRecipe((PassiveHeatSource)recipe)));
        if (Powah.config().general.player_aerial_pearl) {
            registry.addRecipe((EmiRecipe)new EmiInfoRecipe(List.of(EmiStack.of((ItemLike)((ItemLike)Itms.PLAYER_AERIAL_PEARL.get()))), List.of(Component.translatable((String)"jei.powah.player_aerial_pearl")), null));
        }
        if (Powah.config().general.dimensional_binding_card) {
            registry.addRecipe((EmiRecipe)new EmiInfoRecipe(List.of(EmiStack.of((ItemLike)((ItemLike)Itms.BINDING_CARD_DIM.get()))), List.of(Component.translatable((String)"jei.powah.binding_card_dim")), null));
        }
        if (Powah.config().general.lens_of_ender) {
            registry.addRecipe((EmiRecipe)new EmiInfoRecipe(List.of(EmiStack.of((ItemLike)((ItemLike)Itms.LENS_OF_ENDER.get()))), List.of(Component.translatable((String)"jei.powah.lens_of_ender")), null));
        }
        registry.addGenericExclusionArea(PowahEmiPlugin::getExclusionAreas);
    }

    private static <C extends RecipeInput, T extends Recipe<C>> void adaptRecipeType(EmiRegistry registry, RecipeType<T> recipeType, Function<RecipeHolder<T>, ? extends EmiRecipe> adapter) {
        registry.getRecipeManager().getAllRecipesFor(recipeType).stream().map(adapter).forEach(arg_0 -> ((EmiRegistry)registry).addRecipe(arg_0));
    }

    private static void getExclusionAreas(Screen screen, Consumer<Bounds> consumer) {
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            for (Rect2i extraArea : containerScreen.getExtraAreas()) {
                consumer.accept(new Bounds(extraArea.getX(), extraArea.getY(), extraArea.getWidth(), extraArea.getHeight()));
            }
        }
    }
}

