/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.block;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import owmii.powah.lib.block.AbstractTileEntity;
import owmii.powah.lib.block.IBlock;
import owmii.powah.lib.block.IBlockEntity;
import owmii.powah.lib.logistics.inventory.AbstractContainer;
import owmii.powah.lib.registry.IVariant;
import owmii.powah.lib.registry.IVariantEntry;

public abstract class AbstractBlock<V extends IVariant, B extends AbstractBlock<V, B>>
extends Block
implements IVariantEntry<V, B>,
IBlock<V, B> {
    public static final VoxelShape SEMI_FULL_SHAPE = AbstractBlock.box(0.01, 0.01, 0.01, 15.99, 15.99, 15.99);
    protected final Map<Direction, VoxelShape> shapes = new HashMap<Direction, VoxelShape>();
    protected final V variant;

    public AbstractBlock(BlockBehaviour.Properties properties) {
        this(properties, IVariant.getEmpty());
    }

    public AbstractBlock(BlockBehaviour.Properties properties, V variant) {
        super(properties);
        this.variant = variant;
        this.shapes.put(Direction.UP, Shapes.block());
        this.shapes.put(Direction.DOWN, Shapes.block());
        this.shapes.put(Direction.NORTH, Shapes.block());
        this.shapes.put(Direction.SOUTH, Shapes.block());
        this.shapes.put(Direction.EAST, Shapes.block());
        this.shapes.put(Direction.WEST, Shapes.block());
    }

    public static VoxelShape box(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Block.box((double)Math.min(x1, x2), (double)Math.min(y1, y2), (double)Math.min(z1, z2), (double)Math.max(x1, x2), (double)Math.max(y1, y2), (double)Math.max(z1, z2));
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (!this.shapes.isEmpty() && !this.getFacing().equals((Object)Facing.NONE)) {
            return this.shapes.get(state.getValue((Property)BlockStateProperties.FACING));
        }
        return super.getShape(state, worldIn, pos, context);
    }

    public Component getDisplayName(ItemStack stack) {
        return Component.translatable((String)this.asItem().getDescriptionId(stack));
    }

    @Override
    public V getVariant() {
        return this.variant;
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof IBlockEntity) {
            ((IBlockEntity)tile).onAdded(world, state, oldState, isMoving);
        }
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof IBlockEntity) {
            ((IBlockEntity)tile).onRemoved(world, state, newState, isMoving);
        }
        super.onRemove(state, world, pos, newState, isMoving);
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof IBlockEntity) {
            ((IBlockEntity)tile).onPlaced(world, state, placer, stack);
        }
    }

    public void playerDestroy(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        if (te instanceof AbstractTileEntity) {
            AbstractTileEntity tile = (AbstractTileEntity)te;
            ItemStack stack1 = tile.storeToStack(new ItemStack((ItemLike)this));
            AbstractBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)stack1);
            player.awardStat(Stats.BLOCK_MINED.get((Object)this));
            player.causeFoodExhaustion(0.005f);
        } else {
            super.playerDestroy(world, player, pos, state, te, stack);
        }
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (this instanceof SimpleWaterloggedBlock && ((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            world.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        if (!state.canSurvive((LevelReader)world, currentPos)) {
            BlockEntity tileEntity = world.getBlockEntity(currentPos);
            if (!world.isClientSide() && tileEntity instanceof AbstractTileEntity) {
                AbstractTileEntity tile = (AbstractTileEntity)tileEntity;
                ItemStack stack = tile.storeToStack(new ItemStack((ItemLike)this));
                AbstractBlock.popResource((Level)((Level)world), (BlockPos)currentPos, (ItemStack)stack);
                world.destroyBlock(currentPos, false);
            }
        }
        return super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return this.getCloneItemStack(world, pos);
    }

    public ItemStack getCloneItemStack(BlockGetter world, BlockPos pos) {
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof AbstractTileEntity) {
            AbstractTileEntity tile = (AbstractTileEntity)te;
            return tile.storeToStack(new ItemStack((ItemLike)this));
        }
        return new ItemStack((ItemLike)this);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, final BlockHitResult result) {
        MenuProvider provider;
        AbstractContainerMenu container;
        final BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof AbstractTileEntity && (container = (provider = new MenuProvider(){

            public Component getDisplayName() {
                return new ItemStack((ItemLike)AbstractBlock.this).getHoverName();
            }

            @Nullable
            public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
                return AbstractBlock.this.getContainer(i, playerInventory, (AbstractTileEntity)tile, result);
            }
        }).createMenu(0, player.getInventory(), player)) != null) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.openMenu(provider, buffer -> {
                    buffer.writeBlockPos(pos);
                    this.additionalGuiData((FriendlyByteBuf)buffer, state, world, pos, player, result);
                });
            }
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, world, pos, player, result);
    }

    @Nullable
    public <T extends AbstractTileEntity> AbstractContainer getContainer(int id, Inventory inventory, AbstractTileEntity te, BlockHitResult result) {
        return null;
    }

    protected void additionalGuiData(FriendlyByteBuf buffer, BlockState state, Level world, BlockPos pos, Player player, BlockHitResult result) {
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return !state.canOcclude();
    }

    protected void setDefaultState() {
        this.setStateProps(state -> state);
    }

    protected void setStateProps(BaseState baseState) {
        BlockState state = (BlockState)this.stateDefinition.any();
        if (this instanceof SimpleWaterloggedBlock) {
            state = (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        if (!this.getFacing().equals((Object)Facing.NONE)) {
            state = (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH);
        }
        if (this.hasLitProp()) {
            state = (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(false));
        }
        this.registerDefaultState(baseState.get(state));
    }

    protected boolean isPlacerFacing() {
        return false;
    }

    protected Facing getFacing() {
        return Facing.NONE;
    }

    protected boolean hasLitProp() {
        return false;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return this.getFluidState(state).isEmpty() || super.propagatesSkylightDown(state, reader, pos);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = this.defaultBlockState();
        if (this.getFacing().equals((Object)Facing.HORIZONTAL)) {
            state = !this.isPlacerFacing() ? this.facing(context, false) : (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)context.getHorizontalDirection().getOpposite());
        } else if (this.getFacing().equals((Object)Facing.ALL)) {
            state = !this.isPlacerFacing() ? this.facing(context, true) : (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)context.getNearestLookingDirection().getOpposite());
        }
        if (state != null && this instanceof SimpleWaterloggedBlock) {
            FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
            state = (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        }
        return state;
    }

    @Nullable
    private BlockState facing(BlockPlaceContext context, boolean b) {
        BlockState blockstate = this.defaultBlockState();
        for (Direction direction : context.getNearestLookingDirections()) {
            if (!b && !direction.getAxis().isHorizontal() || !(blockstate = (BlockState)blockstate.setValue((Property)BlockStateProperties.FACING, (Comparable)(b ? direction : direction.getOpposite()))).canSurvive((LevelReader)context.getLevel(), context.getClickedPos())) continue;
            return blockstate;
        }
        return null;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        if (this.getFacing().equals((Object)Facing.ALL) || this.getFacing().equals((Object)Facing.HORIZONTAL)) {
            return (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)BlockStateProperties.FACING)));
        }
        return super.rotate(state, rot);
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        if (this.getFacing().equals((Object)Facing.ALL) || this.getFacing().equals((Object)Facing.HORIZONTAL)) {
            return state.rotate(mirror.getRotation((Direction)state.getValue((Property)BlockStateProperties.FACING)));
        }
        return super.mirror(state, mirror);
    }

    public FluidState getFluidState(BlockState state) {
        return this instanceof SimpleWaterloggedBlock && (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int id, int param) {
        BlockEntity tileEntity = world.getBlockEntity(pos);
        return tileEntity != null && tileEntity.triggerEvent(id, param);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        if (this.getFacing().equals((Object)Facing.ALL) || this.getFacing().equals((Object)Facing.HORIZONTAL)) {
            builder.add(new Property[]{BlockStateProperties.FACING});
        }
        if (this instanceof SimpleWaterloggedBlock) {
            builder.add(new Property[]{BlockStateProperties.WATERLOGGED});
        }
        if (this.hasLitProp()) {
            builder.add(new Property[]{BlockStateProperties.LIT});
        }
    }

    protected static enum Facing {
        HORIZONTAL,
        ALL,
        NONE;

    }

    protected static interface BaseState {
        public BlockState get(BlockState var1);
    }
}

