/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.world.gen;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.OrePlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import owmii.powah.Powah;
import owmii.powah.block.Blcks;

public class Features {
    private static final int poor_uraninite_veins_per_chunk = 8;
    private static final int uraninite_veins_per_chunk = 6;
    private static final int dense_uraninite_veins_per_chunk = 3;
    private static final int dry_ice_veins_per_chunk = 9;
    private static final TagKey<Biome> DRY_ICE_BIOME = TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)Powah.id("has_dry_ice"));
    public static final ResourceKey<PlacedFeature> PLACED_DRY_ICE = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)Powah.id("dry_ice"));
    public static final ResourceKey<PlacedFeature> PLACED_URANINITE_POOR = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)Powah.id("uraninite_ore_poor"));
    public static final ResourceKey<PlacedFeature> PLACED_URANINITE = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)Powah.id("uraninite_ore"));
    public static final ResourceKey<PlacedFeature> PLACED_URANINITE_DENSE = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)Powah.id("uraninite_ore_dense"));
    public static final ResourceKey<ConfiguredFeature<?, ?>> DRY_ICE = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)Powah.id("dry_ice"));
    public static final ResourceKey<ConfiguredFeature<?, ?>> URANINITE_POOR = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)Powah.id("uraninite_ore_poor"));
    public static final ResourceKey<ConfiguredFeature<?, ?>> URANINITE = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)Powah.id("uraninite_ore"));
    public static final ResourceKey<ConfiguredFeature<?, ?>> URANINITE_DENSE = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)Powah.id("uraninite_ore_dense"));

    public static void initConfiguredFeatures(BootstrapContext<ConfiguredFeature<?, ?>> bootstrap) {
        Features.registerConfiguredFeature(bootstrap, DRY_ICE, Blcks.DRY_ICE, Blcks.DRY_ICE, 17);
        Features.registerConfiguredFeature(bootstrap, URANINITE_POOR, Blcks.URANINITE_ORE_POOR, Blcks.DEEPSLATE_URANINITE_ORE_POOR, 5);
        Features.registerConfiguredFeature(bootstrap, URANINITE, Blcks.URANINITE_ORE, Blcks.DEEPSLATE_URANINITE_ORE, 4);
        Features.registerConfiguredFeature(bootstrap, URANINITE_DENSE, Blcks.URANINITE_ORE_DENSE, Blcks.DEEPSLATE_URANINITE_ORE_DENSE, 3);
    }

    public static void initPlacedFeatures(BootstrapContext<PlacedFeature> bootstrap) {
        Features.registerPlacedFeature(bootstrap, PLACED_DRY_ICE, DRY_ICE, 9, 64);
        Features.registerPlacedFeature(bootstrap, PLACED_URANINITE_POOR, URANINITE_POOR, 8, 64);
        Features.registerPlacedFeature(bootstrap, PLACED_URANINITE, URANINITE, 6, 20);
        Features.registerPlacedFeature(bootstrap, PLACED_URANINITE_DENSE, URANINITE_DENSE, 3, 0);
    }

    private static void registerConfiguredFeature(BootstrapContext<ConfiguredFeature<?, ?>> bootstrap, ResourceKey<ConfiguredFeature<?, ?>> key, Supplier<Block> block, Supplier<Block> deepslateBlock, int amountPerVein) {
        List<OreConfiguration.TargetBlockState> target = List.of(OreConfiguration.target((RuleTest)new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES), (BlockState)block.get().defaultBlockState()), OreConfiguration.target((RuleTest)new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES), (BlockState)deepslateBlock.get().defaultBlockState()));
        ConfiguredFeature conf = new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration(target, amountPerVein));
        bootstrap.register(key, (Object)conf);
    }

    private static void registerPlacedFeature(BootstrapContext<PlacedFeature> bootstrap, ResourceKey<PlacedFeature> key, ResourceKey<ConfiguredFeature<?, ?>> configuredId, int veinsPerChunk, int maxY) {
        Holder.Reference configuredFeature = (Holder.Reference)bootstrap.lookup(Registries.CONFIGURED_FEATURE).get(configuredId).orElseThrow();
        PlacedFeature placed = new PlacedFeature((Holder)configuredFeature, OrePlacements.commonOrePlacement((int)veinsPerChunk, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)maxY))));
        bootstrap.register(key, (Object)placed);
    }

    public static void initBiomeModifiers(BootstrapContext<BiomeModifier> bootstrap) {
        HolderGetter biomes = bootstrap.lookup(Registries.BIOME);
        HolderSet.Named overworldBiomes = biomes.getOrThrow(BiomeTags.IS_OVERWORLD);
        Features.addFeatureToBiomes(bootstrap, (HolderSet<Biome>)overworldBiomes, PLACED_URANINITE_POOR, GenerationStep.Decoration.UNDERGROUND_ORES);
        Features.addFeatureToBiomes(bootstrap, (HolderSet<Biome>)overworldBiomes, PLACED_URANINITE, GenerationStep.Decoration.UNDERGROUND_ORES);
        Features.addFeatureToBiomes(bootstrap, (HolderSet<Biome>)overworldBiomes, PLACED_URANINITE_DENSE, GenerationStep.Decoration.UNDERGROUND_ORES);
        HolderSet.Named dryIceBiomes = biomes.getOrThrow(DRY_ICE_BIOME);
        Features.addFeatureToBiomes(bootstrap, (HolderSet<Biome>)dryIceBiomes, PLACED_DRY_ICE, GenerationStep.Decoration.UNDERGROUND_ORES);
    }

    private static void addFeatureToBiomes(BootstrapContext<BiomeModifier> bootstrap, HolderSet<Biome> biomes, ResourceKey<PlacedFeature> featureKey, GenerationStep.Decoration step) {
        ResourceKey modifierKey = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)featureKey.location());
        HolderGetter features = bootstrap.lookup(Registries.PLACED_FEATURE);
        BiomeModifiers.AddFeaturesBiomeModifier modifier = new BiomeModifiers.AddFeaturesBiomeModifier(biomes, (HolderSet)HolderSet.direct((Holder[])new Holder[]{features.getOrThrow(featureKey)}), step);
        bootstrap.register(modifierKey, (Object)modifier);
    }
}

