/*
 * Decompiled with CFR 0.152.
 */
package fr.harmex.cobblebadges.common.client.gui.widget;

import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.api.gui.GuiUtilsKt;
import com.mojang.blaze3d.vertex.PoseStack;
import fr.harmex.cobblebadges.common.network.CobbleBadgesNetwork;
import fr.harmex.cobblebadges.common.network.packet.c2s.ToggleBadgePacket;
import fr.harmex.cobblebadges.common.utils.MiscUtilsKt;
import fr.harmex.cobblebadges.common.world.badge.PlayerBadge;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 $2\u00020\u0001:\u0001$B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ/\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\rH\u0014\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001d\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001d\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0014J\u0017\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001dH\u0014\u00a2\u0006\u0004\b\u001f\u0010 R\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010!\u001a\u0004\b\"\u0010#\u00a8\u0006%"}, d2={"Lfr/harmex/cobblebadges/common/client/gui/widget/BadgeWidget;", "Lnet/minecraft/client/gui/components/AbstractWidget;", "", "x", "y", "Lfr/harmex/cobblebadges/common/world/badge/PlayerBadge;", "badge", "<init>", "(IILfr/harmex/cobblebadges/common/world/badge/PlayerBadge;)V", "Lnet/minecraft/client/gui/GuiGraphics;", "guiGraphics", "mouseX", "mouseY", "", "partialTick", "", "renderWidget", "(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", "", "isMouseOverBadge", "(II)Z", "isMouseOverButton", "Lnet/minecraft/client/sounds/SoundManager;", "handler", "playDownSound", "(Lnet/minecraft/client/sounds/SoundManager;)V", "", "onClick", "(DD)V", "Lnet/minecraft/client/gui/narration/NarrationElementOutput;", "narrationElementOutput", "updateWidgetNarration", "(Lnet/minecraft/client/gui/narration/NarrationElementOutput;)V", "Lfr/harmex/cobblebadges/common/world/badge/PlayerBadge;", "getBadge", "()Lfr/harmex/cobblebadges/common/world/badge/PlayerBadge;", "Companion", "common"})
public final class BadgeWidget
extends AbstractWidget {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlayerBadge badge;
    public static final int WIDTH = 42;
    public static final int HEIGHT = 56;
    @NotNull
    private static final ResourceLocation BACKGROUND_LOCATION = MiscUtilsKt.cobbleBadgesResource("textures/gui/badge_case/widget_background.png");
    @NotNull
    private static final ResourceLocation BADGE_OUTLINE_LOCATION = MiscUtilsKt.cobbleBadgesResource("textures/gui/badge_case/badge_outline.png");
    @NotNull
    private static final ResourceLocation BUTTONS_LOCATION = MiscUtilsKt.cobbleBadgesResource("textures/gui/badge_case/buttons.png");

    public BadgeWidget(int x, int y, @NotNull PlayerBadge badge) {
        Intrinsics.checkNotNullParameter((Object)badge, (String)"badge");
        super(x, y, 42, 56, (Component)badge.getHoverName());
        this.badge = badge;
    }

    @NotNull
    public final PlayerBadge getBadge() {
        return this.badge;
    }

    protected void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Intrinsics.checkNotNullParameter((Object)guiGraphics, (String)"guiGraphics");
        PoseStack poseStack = guiGraphics.pose();
        Intrinsics.checkNotNullExpressionValue((Object)poseStack, (String)"pose(...)");
        GuiUtilsKt.blitk$default((PoseStack)poseStack, (ResourceLocation)BACKGROUND_LOCATION, (Number)this.getX(), (Number)this.getY(), (Number)56, (Number)42, null, null, null, null, null, null, null, null, null, (boolean)false, (float)0.0f, (int)131008, null);
        fr.harmex.cobblebadges.common.client.utils.GuiUtilsKt.renderBadge(guiGraphics, this.getX() + 3, this.getY() + 3, this.badge);
        if (this.isMouseOverBadge(mouseX, mouseY)) {
            PoseStack poseStack2 = guiGraphics.pose();
            Intrinsics.checkNotNullExpressionValue((Object)poseStack2, (String)"pose(...)");
            GuiUtilsKt.blitk$default((PoseStack)poseStack2, (ResourceLocation)BADGE_OUTLINE_LOCATION, (Number)(this.getX() + 2), (Number)(this.getY() + 2), (Number)38, (Number)38, null, null, null, null, null, null, null, null, null, (boolean)false, (float)0.0f, (int)131008, null);
        }
        int buttonVOffset = this.isMouseOverButton(mouseX, mouseY) ? (this.badge.isActive() ? 13 : 39) : (this.badge.isActive() ? 0 : 26);
        PoseStack poseStack3 = guiGraphics.pose();
        Intrinsics.checkNotNullExpressionValue((Object)poseStack3, (String)"pose(...)");
        GuiUtilsKt.blitk$default((PoseStack)poseStack3, (ResourceLocation)BUTTONS_LOCATION, (Number)(this.getX() + 6), (Number)(this.getY() + 41), (Number)13, (Number)30, (Number)0, (Number)buttonVOffset, (Number)30, (Number)52, null, null, null, null, null, (boolean)false, (float)0.0f, (int)130048, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isMouseOverBadge(int mouseX, int mouseY) {
        int n = this.getX() + 3;
        if (mouseX > this.getX() + 39) return false;
        if (n > mouseX) return false;
        boolean bl = true;
        if (!bl) return false;
        n = this.getY() + 3;
        if (mouseY > this.getY() + 39) return false;
        if (n > mouseY) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isMouseOverButton(int mouseX, int mouseY) {
        int n = this.getX() + 6;
        if (mouseX > this.getX() + 36) return false;
        if (n > mouseX) return false;
        boolean bl = true;
        if (!bl) return false;
        n = this.getY() + 41;
        if (mouseY > this.getY() + 54) return false;
        if (n > mouseY) return false;
        return true;
    }

    public void playDownSound(@NotNull SoundManager handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
    }

    public void onClick(double mouseX, double mouseY) {
        if (this.isMouseOverButton((int)mouseX, (int)mouseY)) {
            CobbleBadgesNetwork.INSTANCE.sendToServer(new ToggleBadgePacket(this.badge, !this.badge.isActive()));
            this.badge.setActive(!this.badge.isActive());
            Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)CobblemonSounds.GUI_CLICK, (float)1.0f));
        }
    }

    protected void updateWidgetNarration(@NotNull NarrationElementOutput narrationElementOutput) {
        Intrinsics.checkNotNullParameter((Object)narrationElementOutput, (String)"narrationElementOutput");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\nR\u0014\u0010\f\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\n\u00a8\u0006\r"}, d2={"Lfr/harmex/cobblebadges/common/client/gui/widget/BadgeWidget$Companion;", "", "<init>", "()V", "", "WIDTH", "I", "HEIGHT", "Lnet/minecraft/resources/ResourceLocation;", "BACKGROUND_LOCATION", "Lnet/minecraft/resources/ResourceLocation;", "BADGE_OUTLINE_LOCATION", "BUTTONS_LOCATION", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

