/*
 * Decompiled with CFR 0.152.
 */
package fr.harmex.cobblebadges.common.world.badge;

import fr.harmex.cobblebadges.common.core.registries.CobbleBadgesRegistries;
import fr.harmex.cobblebadges.common.utils.MiscUtilsKt;
import fr.harmex.cobblebadges.common.world.badge.Badge;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001:\u0001\u0013J)\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eR\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lfr/harmex/cobblebadges/common/world/badge/AttributeBadge;", "Lfr/harmex/cobblebadges/common/world/badge/Badge;", "Lnet/minecraft/world/entity/player/Player;", "player", "", "tier", "", "isActive", "", "updateAttributes", "(Lnet/minecraft/world/entity/player/Player;IZ)V", "", "Lnet/minecraft/network/chat/Component;", "getAttributesTooltip", "(I)Ljava/util/List;", "Lfr/harmex/cobblebadges/common/world/badge/AttributeBadge$BadgeAttributeInfo;", "getAttributeInfos", "()Ljava/util/List;", "attributeInfos", "BadgeAttributeInfo", "common"})
public interface AttributeBadge
extends Badge {
    @NotNull
    public List<BadgeAttributeInfo> getAttributeInfos();

    public void updateAttributes(@NotNull Player var1, int var2, boolean var3);

    @NotNull
    public List<Component> getAttributesTooltip(int var1);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\f\b\u0086\b\u0018\u00002\u00020\u0001B=\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0019\u0010\u0018J\u0015\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u001a\u0010\u0018J\u0015\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u001b\u0010\u0018J\u001d\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b \u0010!J\u0010\u0010\"\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\"\u0010#J\u0010\u0010$\u001a\u00020\u0007H\u00c6\u0003\u00a2\u0006\u0004\b$\u0010%J\u0010\u0010&\u001a\u00020\u0007H\u00c6\u0003\u00a2\u0006\u0004\b&\u0010%J\u0010\u0010'\u001a\u00020\u0007H\u00c6\u0003\u00a2\u0006\u0004\b'\u0010%J\u0010\u0010(\u001a\u00020\u0007H\u00c6\u0003\u00a2\u0006\u0004\b(\u0010%JR\u0010)\u001a\u00020\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u00072\b\b\u0002\u0010\u000b\u001a\u00020\u0007H\u00c6\u0001\u00a2\u0006\u0004\b)\u0010*J\u001a\u0010-\u001a\u00020,2\b\u0010+\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b-\u0010.J\u0010\u0010/\u001a\u00020\u001cH\u00d6\u0001\u00a2\u0006\u0004\b/\u00100J\u0010\u00102\u001a\u000201H\u00d6\u0001\u00a2\u0006\u0004\b2\u00103R\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u00104\u001a\u0004\b5\u0010!R\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u00106\u001a\u0004\b7\u0010#R\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u00108\u001a\u0004\b9\u0010%R\u0017\u0010\t\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\t\u00108\u001a\u0004\b:\u0010%R\u0017\u0010\n\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\n\u00108\u001a\u0004\b;\u0010%R\u0017\u0010\u000b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\u000b\u00108\u001a\u0004\b<\u0010%\u00a8\u0006="}, d2={"Lfr/harmex/cobblebadges/common/world/badge/AttributeBadge$BadgeAttributeInfo;", "", "Lnet/minecraft/core/Holder;", "Lnet/minecraft/world/entity/ai/attributes/Attribute;", "attribute", "Lnet/minecraft/world/entity/ai/attributes/AttributeModifier$Operation;", "operation", "", "normalValue", "greatValue", "ultraValue", "masterValue", "<init>", "(Lnet/minecraft/core/Holder;Lnet/minecraft/world/entity/ai/attributes/AttributeModifier$Operation;DDDD)V", "Lfr/harmex/cobblebadges/common/world/badge/Badge;", "badge", "Lnet/minecraft/resources/ResourceLocation;", "getModifierId", "(Lfr/harmex/cobblebadges/common/world/badge/Badge;)Lnet/minecraft/resources/ResourceLocation;", "value", "Lnet/minecraft/world/entity/ai/attributes/AttributeModifier;", "createModifier", "(Lfr/harmex/cobblebadges/common/world/badge/Badge;D)Lnet/minecraft/world/entity/ai/attributes/AttributeModifier;", "getNormalModifier", "(Lfr/harmex/cobblebadges/common/world/badge/Badge;)Lnet/minecraft/world/entity/ai/attributes/AttributeModifier;", "getGreatModifier", "getUltraModifier", "getMasterModifier", "", "tier", "getModifierByTier", "(Lfr/harmex/cobblebadges/common/world/badge/Badge;I)Lnet/minecraft/world/entity/ai/attributes/AttributeModifier;", "component1", "()Lnet/minecraft/core/Holder;", "component2", "()Lnet/minecraft/world/entity/ai/attributes/AttributeModifier$Operation;", "component3", "()D", "component4", "component5", "component6", "copy", "(Lnet/minecraft/core/Holder;Lnet/minecraft/world/entity/ai/attributes/AttributeModifier$Operation;DDDD)Lfr/harmex/cobblebadges/common/world/badge/AttributeBadge$BadgeAttributeInfo;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/core/Holder;", "getAttribute", "Lnet/minecraft/world/entity/ai/attributes/AttributeModifier$Operation;", "getOperation", "D", "getNormalValue", "getGreatValue", "getUltraValue", "getMasterValue", "common"})
    public static final class BadgeAttributeInfo {
        @NotNull
        private final Holder<Attribute> attribute;
        @NotNull
        private final AttributeModifier.Operation operation;
        private final double normalValue;
        private final double greatValue;
        private final double ultraValue;
        private final double masterValue;

        public BadgeAttributeInfo(@NotNull Holder<Attribute> attribute, @NotNull AttributeModifier.Operation operation, double normalValue, double greatValue, double ultraValue, double masterValue) {
            Intrinsics.checkNotNullParameter(attribute, (String)"attribute");
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            this.attribute = attribute;
            this.operation = operation;
            this.normalValue = normalValue;
            this.greatValue = greatValue;
            this.ultraValue = ultraValue;
            this.masterValue = masterValue;
        }

        @NotNull
        public final Holder<Attribute> getAttribute() {
            return this.attribute;
        }

        @NotNull
        public final AttributeModifier.Operation getOperation() {
            return this.operation;
        }

        public final double getNormalValue() {
            return this.normalValue;
        }

        public final double getGreatValue() {
            return this.greatValue;
        }

        public final double getUltraValue() {
            return this.ultraValue;
        }

        public final double getMasterValue() {
            return this.masterValue;
        }

        @NotNull
        public final ResourceLocation getModifierId(@NotNull Badge badge) {
            Intrinsics.checkNotNullParameter((Object)badge, (String)"badge");
            ResourceLocation resourceLocation = CobbleBadgesRegistries.INSTANCE.getBADGE().getKey((Object)badge);
            Intrinsics.checkNotNull((Object)resourceLocation);
            return resourceLocation;
        }

        private final AttributeModifier createModifier(Badge badge, double value) {
            return new AttributeModifier(this.getModifierId(badge), value, this.operation);
        }

        @NotNull
        public final AttributeModifier getNormalModifier(@NotNull Badge badge) {
            Intrinsics.checkNotNullParameter((Object)badge, (String)"badge");
            return this.createModifier(badge, this.normalValue);
        }

        @NotNull
        public final AttributeModifier getGreatModifier(@NotNull Badge badge) {
            Intrinsics.checkNotNullParameter((Object)badge, (String)"badge");
            return this.createModifier(badge, this.greatValue);
        }

        @NotNull
        public final AttributeModifier getUltraModifier(@NotNull Badge badge) {
            Intrinsics.checkNotNullParameter((Object)badge, (String)"badge");
            return this.createModifier(badge, this.ultraValue);
        }

        @NotNull
        public final AttributeModifier getMasterModifier(@NotNull Badge badge) {
            Intrinsics.checkNotNullParameter((Object)badge, (String)"badge");
            return this.createModifier(badge, this.masterValue);
        }

        @NotNull
        public final AttributeModifier getModifierByTier(@NotNull Badge badge, int tier) {
            Intrinsics.checkNotNullParameter((Object)badge, (String)"badge");
            return switch (tier) {
                case 1 -> this.getNormalModifier(badge);
                case 2 -> this.getGreatModifier(badge);
                case 3 -> this.getUltraModifier(badge);
                case 4 -> this.getMasterModifier(badge);
                default -> throw new IllegalArgumentException();
            };
        }

        @NotNull
        public final Holder<Attribute> component1() {
            return this.attribute;
        }

        @NotNull
        public final AttributeModifier.Operation component2() {
            return this.operation;
        }

        public final double component3() {
            return this.normalValue;
        }

        public final double component4() {
            return this.greatValue;
        }

        public final double component5() {
            return this.ultraValue;
        }

        public final double component6() {
            return this.masterValue;
        }

        @NotNull
        public final BadgeAttributeInfo copy(@NotNull Holder<Attribute> attribute, @NotNull AttributeModifier.Operation operation, double normalValue, double greatValue, double ultraValue, double masterValue) {
            Intrinsics.checkNotNullParameter(attribute, (String)"attribute");
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            return new BadgeAttributeInfo(attribute, operation, normalValue, greatValue, ultraValue, masterValue);
        }

        public static /* synthetic */ BadgeAttributeInfo copy$default(BadgeAttributeInfo badgeAttributeInfo, Holder holder, AttributeModifier.Operation operation, double d, double d2, double d3, double d4, int n, Object object) {
            if ((n & 1) != 0) {
                holder = badgeAttributeInfo.attribute;
            }
            if ((n & 2) != 0) {
                operation = badgeAttributeInfo.operation;
            }
            if ((n & 4) != 0) {
                d = badgeAttributeInfo.normalValue;
            }
            if ((n & 8) != 0) {
                d2 = badgeAttributeInfo.greatValue;
            }
            if ((n & 0x10) != 0) {
                d3 = badgeAttributeInfo.ultraValue;
            }
            if ((n & 0x20) != 0) {
                d4 = badgeAttributeInfo.masterValue;
            }
            return badgeAttributeInfo.copy(holder, operation, d, d2, d3, d4);
        }

        @NotNull
        public String toString() {
            return "BadgeAttributeInfo(attribute=" + this.attribute + ", operation=" + this.operation + ", normalValue=" + this.normalValue + ", greatValue=" + this.greatValue + ", ultraValue=" + this.ultraValue + ", masterValue=" + this.masterValue + ")";
        }

        public int hashCode() {
            int result = this.attribute.hashCode();
            result = result * 31 + this.operation.hashCode();
            result = result * 31 + Double.hashCode(this.normalValue);
            result = result * 31 + Double.hashCode(this.greatValue);
            result = result * 31 + Double.hashCode(this.ultraValue);
            result = result * 31 + Double.hashCode(this.masterValue);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BadgeAttributeInfo)) {
                return false;
            }
            BadgeAttributeInfo badgeAttributeInfo = (BadgeAttributeInfo)other;
            if (!Intrinsics.areEqual(this.attribute, badgeAttributeInfo.attribute)) {
                return false;
            }
            if (this.operation != badgeAttributeInfo.operation) {
                return false;
            }
            if (Double.compare(this.normalValue, badgeAttributeInfo.normalValue) != 0) {
                return false;
            }
            if (Double.compare(this.greatValue, badgeAttributeInfo.greatValue) != 0) {
                return false;
            }
            if (Double.compare(this.ultraValue, badgeAttributeInfo.ultraValue) != 0) {
                return false;
            }
            return Double.compare(this.masterValue, badgeAttributeInfo.masterValue) == 0;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nAttributeBadge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttributeBadge.kt\nfr/harmex/cobblebadges/common/world/badge/AttributeBadge$DefaultImpls\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n1863#2,2:85\n*S KotlinDebug\n*F\n+ 1 AttributeBadge.kt\nfr/harmex/cobblebadges/common/world/badge/AttributeBadge$DefaultImpls\n*L\n16#1:85,2\n*E\n"})
    public static final class DefaultImpls {
        public static void updateAttributes(@NotNull AttributeBadge $this, @NotNull Player player, int tier, boolean isActive) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Iterable $this$forEach$iv = $this.getAttributeInfos();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BadgeAttributeInfo attributeInfo = (BadgeAttributeInfo)element$iv;
                boolean bl = false;
                AttributeInstance instance = player.getAttribute(attributeInfo.getAttribute());
                if (tier != 0 && isActive) {
                    AttributeInstance attributeInstance = instance;
                    if (attributeInstance != null) {
                        attributeInstance.addOrReplacePermanentModifier(attributeInfo.getModifierByTier($this, tier));
                    }
                    continue;
                }
                AttributeInstance attributeInstance = instance;
                if (attributeInstance == null) continue;
                attributeInstance.removeModifier(attributeInfo.getModifierId($this));
            }
        }

        public static /* synthetic */ void updateAttributes$default(AttributeBadge attributeBadge, Player player, int n, boolean bl, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: updateAttributes");
            }
            if ((n2 & 4) != 0) {
                bl = true;
            }
            attributeBadge.updateAttributes(player, n, bl);
        }

        @NotNull
        public static List<Component> getAttributesTooltip(@NotNull AttributeBadge $this, int tier) {
            List attributesTooltip = new ArrayList();
            for (BadgeAttributeInfo attributeInfo : $this.getAttributeInfos()) {
                MutableComponent mutableComponent;
                double modifierAmountToDisplay;
                double modifierAmount = switch (tier) {
                    case 1 -> attributeInfo.getNormalValue();
                    case 2 -> attributeInfo.getGreatValue();
                    case 3 -> attributeInfo.getUltraValue();
                    case 4 -> attributeInfo.getMasterValue();
                    default -> 0.0;
                };
                double d = modifierAmountToDisplay = attributeInfo.getOperation() == AttributeModifier.Operation.ADD_MULTIPLIED_BASE || attributeInfo.getOperation() == AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL ? modifierAmount * 100.0 : modifierAmount;
                if (modifierAmount >= 0.0) {
                    var10_8 = new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(modifierAmountToDisplay), Component.translatable((String)((Attribute)attributeInfo.getAttribute().value()).getDescriptionId())};
                    mutableComponent = Component.translatable((String)("attribute.modifier.plus." + attributeInfo.getOperation().id()), (Object[])var10_8);
                } else {
                    var10_8 = new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(-modifierAmountToDisplay), Component.translatable((String)((Attribute)attributeInfo.getAttribute().value()).getDescriptionId())};
                    mutableComponent = Component.translatable((String)("attribute.modifier.take." + attributeInfo.getOperation().id()), (Object[])var10_8);
                }
                MutableComponent attributeComponent = mutableComponent;
                MutableComponent mutableComponent2 = MiscUtilsKt.lineStart().append((Component)attributeComponent);
                Intrinsics.checkNotNullExpressionValue((Object)mutableComponent2, (String)"append(...)");
                attributesTooltip.add(mutableComponent2);
            }
            return attributesTooltip;
        }

        public static void tick(@NotNull AttributeBadge $this, @NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Badge.DefaultImpls.tick($this, player);
        }

        public static boolean canTierUp(@NotNull AttributeBadge $this, @NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            return Badge.DefaultImpls.canTierUp($this, player);
        }

        public static boolean canTierDown(@NotNull AttributeBadge $this, @NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            return Badge.DefaultImpls.canTierDown($this, player);
        }

        public static void onPlayerAttackLivingEntity(@NotNull AttributeBadge $this, @NotNull Player player, @NotNull LivingEntity livingEntity, int tier, boolean isBadgeActive) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
            Badge.DefaultImpls.onPlayerAttackLivingEntity($this, player, livingEntity, tier, isBadgeActive);
        }

        @NotNull
        public static List<Component> getCustomEffectTooltip(@NotNull AttributeBadge $this, int tier) {
            return Badge.DefaultImpls.getCustomEffectTooltip($this, tier);
        }

        public static int getMaxTier(@NotNull AttributeBadge $this) {
            return Badge.DefaultImpls.getMaxTier($this);
        }

        @NotNull
        public static String getDescriptionId(@NotNull AttributeBadge $this) {
            return Badge.DefaultImpls.getDescriptionId($this);
        }

        @NotNull
        public static MutableComponent getName(@NotNull AttributeBadge $this) {
            return Badge.DefaultImpls.getName($this);
        }

        @NotNull
        public static MutableComponent getHoverName(@NotNull AttributeBadge $this) {
            return Badge.DefaultImpls.getHoverName($this);
        }

        @NotNull
        public static MutableComponent getDisplayName(@NotNull AttributeBadge $this) {
            return Badge.DefaultImpls.getDisplayName($this);
        }
    }
}

