/*
 * Decompiled with CFR 0.152.
 */
package fr.harmex.cobblebadges.common.world.badge;

import fr.harmex.cobblebadges.common.CobbleBadges;
import fr.harmex.cobblebadges.common.core.registries.CobbleBadgesRegistries;
import fr.harmex.cobblebadges.common.utils.MiscUtilsKt;
import fr.harmex.cobblebadges.common.utils.extensions.PlayerExtensionKt;
import fr.harmex.cobblebadges.common.world.badge.Point;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\bf\u0018\u00002\u00020\u0001J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\b\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\n\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\n\u0010\tJ/\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001d\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u00128&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010 \u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010$\u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010&\u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010#R\u0014\u0010(\u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010#R\u0014\u0010*\u001a\u00020\r8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0017\u00a8\u0006+"}, d2={"Lfr/harmex/cobblebadges/common/world/badge/Badge;", "", "Lnet/minecraft/world/entity/player/Player;", "player", "", "tick", "(Lnet/minecraft/world/entity/player/Player;)V", "", "canTierUp", "(Lnet/minecraft/world/entity/player/Player;)Z", "canTierDown", "Lnet/minecraft/world/entity/LivingEntity;", "livingEntity", "", "tier", "isBadgeActive", "onPlayerAttackLivingEntity", "(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/entity/LivingEntity;IZ)V", "", "Lnet/minecraft/network/chat/Component;", "getCustomEffectTooltip", "(I)Ljava/util/List;", "getMaxTier", "()I", "maxTier", "Lfr/harmex/cobblebadges/common/world/badge/Point;", "getPointsToTierUp", "()Ljava/util/List;", "pointsToTierUp", "", "getDescriptionId", "()Ljava/lang/String;", "descriptionId", "Lnet/minecraft/network/chat/MutableComponent;", "getName", "()Lnet/minecraft/network/chat/MutableComponent;", "name", "getHoverName", "hoverName", "getDisplayName", "displayName", "getColor", "color", "common"})
public interface Badge {
    public int getMaxTier();

    @NotNull
    public List<Point> getPointsToTierUp();

    @NotNull
    public String getDescriptionId();

    @NotNull
    public MutableComponent getName();

    @NotNull
    public MutableComponent getHoverName();

    @NotNull
    public MutableComponent getDisplayName();

    public int getColor();

    public void tick(@NotNull Player var1);

    public boolean canTierUp(@NotNull Player var1);

    public boolean canTierDown(@NotNull Player var1);

    public void onPlayerAttackLivingEntity(@NotNull Player var1, @NotNull LivingEntity var2, int var3, boolean var4);

    @NotNull
    public List<Component> getCustomEffectTooltip(int var1);

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        public static int getMaxTier(@NotNull Badge $this) {
            return 4;
        }

        @NotNull
        public static String getDescriptionId(@NotNull Badge $this) {
            String string = Util.makeDescriptionId((String)"badge", (ResourceLocation)CobbleBadgesRegistries.INSTANCE.getBADGE().getKey((Object)$this));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"makeDescriptionId(...)");
            return string;
        }

        @NotNull
        public static MutableComponent getName(@NotNull Badge $this) {
            MutableComponent mutableComponent = com.cobblemon.mod.common.util.MiscUtilsKt.asTranslated((String)$this.getDescriptionId());
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"asTranslated(...)");
            return mutableComponent;
        }

        @NotNull
        public static MutableComponent getHoverName(@NotNull Badge $this) {
            Object[] objectArray = new Object[]{"", $this.getName()};
            MutableComponent mutableComponent = MiscUtilsKt.cobbleBadgesBadge(objectArray).withColor($this.getColor());
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withColor(...)");
            return mutableComponent;
        }

        @NotNull
        public static MutableComponent getDisplayName(@NotNull Badge $this) {
            MutableComponent mutableComponent = ComponentUtils.wrapInSquareBrackets((Component)((Component)$this.getHoverName()));
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"wrapInSquareBrackets(...)");
            return mutableComponent;
        }

        public static void tick(@NotNull Badge $this, @NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        }

        public static boolean canTierUp(@NotNull Badge $this, @NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            int points = PlayerExtensionKt.getPoints(player, $this.getPointsToTierUp().get(0));
            int currentTier = PlayerExtensionKt.getBadgeTier(player, $this);
            return points >= CobbleBadges.INSTANCE.getConfig().getAmountOfPointsForEachTier() * (currentTier + 1) && currentTier < $this.getMaxTier();
        }

        public static boolean canTierDown(@NotNull Badge $this, @NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            int points = PlayerExtensionKt.getPoints(player, $this.getPointsToTierUp().get(0));
            int currentTier = PlayerExtensionKt.getBadgeTier(player, $this);
            return points < CobbleBadges.INSTANCE.getConfig().getAmountOfPointsForEachTier() * currentTier && currentTier > 0;
        }

        public static void onPlayerAttackLivingEntity(@NotNull Badge $this, @NotNull Player player, @NotNull LivingEntity livingEntity, int tier, boolean isBadgeActive) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        }

        @NotNull
        public static List<Component> getCustomEffectTooltip(@NotNull Badge $this, int tier) {
            return CollectionsKt.emptyList();
        }
    }
}

